<?php
require 'vendor/autoload.php';
use RobThree\Auth\TwoFactorAuth;

session_start();

$tfa = new TwoFactorAuth('MyApp');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $secret = $tfa->createSecret();
    file_put_contents('users.json', json_encode([
        'username' => $username,
        'password' => $password,
        'secret' => $secret
    ]));
    $_SESSION['temp_user'] = ['username' => $username, 'secret' => $secret];
    header('Location: setup-2fa.php');
    exit;
}
?>
<form method="post">
    Username: <input name="username"><br>
    Password: <input type="password" name="password"><br>
    <button type="submit">Register</button>
</form>