<?php
require 'vendor/autoload.php';
use RobThree\Auth\TwoFactorAuth;

session_start();
$tfa = new TwoFactorAuth('MyApp');
$user = $_SESSION['temp_user'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($tfa->verifyCode($user['secret'], $_POST['code'])) {
        $_SESSION['user_id'] = $user['username'];
        unset($_SESSION['temp_user']);
        header("Location: index.php");
        exit;
    } else {
        echo "Invalid code.";
    }
}
?>
<form method="post">
    Enter 2FA Code: <input name="code"><br>
    <button type="submit">Verify</button>
</form>