<?php
require 'vendor/autoload.php';
use RobThree\Auth\TwoFactorAuth;

session_start();

$tfa = new TwoFactorAuth('MyApp');

if (!isset($_SESSION['temp_user'])) {
    die("No registration data found.");
}

$user = $_SESSION['temp_user'];
$qrCodeUrl = $tfa->getQRCodeImageAsDataUri($user['username'], $user['secret']);
?>
<h2>Scan this QR Code with your Authenticator app:</h2>
<img src="<?= $qrCodeUrl ?>"><br>
<form method="post" action="verify-2fa.php">
    Enter the code from the app: <input name="code">
    <button type="submit">Verify</button>
</form>