const canvas = document.getElementById('canvas');
const ctx = canvas.getContext('2d');
let img = new Image();
let rotation = 0;
let currentFilter = 'none';

document.getElementById('upload').addEventListener('change', (e) => {
  const reader = new FileReader();
  reader.onload = function(event) {
    img.onload = () => {
      canvas.width = img.width;
      canvas.height = img.height;
      drawImage();
    };
    img.src = event.target.result;
  };
  reader.readAsDataURL(e.target.files[0]);
});

function drawImage() {
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.save();
  ctx.filter = currentFilter;

  // rotate around center
  const cx = canvas.width / 2;
  const cy = canvas.height / 2;
  ctx.translate(cx, cy);
  ctx.rotate(rotation * Math.PI / 180);
  ctx.drawImage(img, -img.width / 2, -img.height / 2);
  ctx.restore();
}

function rotate() {
  rotation = (rotation + 90) % 360;
  drawImage();
}

function applyFilter(filter) {
  currentFilter = filter;
  drawImage();
}

function exportImage() {
  const link = document.createElement('a');
  link.download = 'edited-image.png';
  link.href = canvas.toDataURL();
  link.click();
}
