<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Megan & Loukas Wedding</title>
    <link href="https://fonts.googleapis.com/css?family=Open+Sans|Roboto" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="https://cdn.materialdesignicons.com/2.1.19/css/materialdesignicons.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/datepicker.css">
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            background: #fff;
            margin-top:6%;
        }
        .card-columns {
            column-count: 2;
        }
        .card {
            border-radius: 0;
            border: 0;
        }
        .card .card-img-top {
            border-radius: 0;
        }
    </style>
</head>
<body>
<nav class="navbar navbar-expand-lg navbar-light fixed-top bg-light">
    <div class="container-fluid">
        <a class="navbar-brand" href="index.php"><img src="images/logo/MOMMYAMBOL.png" alt=""></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavDropdown"
                aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNavDropdown">
            <ul class="navbar-nav mr-auto">
                <li class="nav-item">
                    <a class="nav-link" href="index.php">Home <span class="sr-only">(current)</span></a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="pricing.php">Pricing</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="real-weddings.php">Inspiration</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="gallery.php">Gallery</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="contact.php">Contact us</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="about.php">About us</a>
                </li>
            </ul>
            <div class="form-inline mr-2">
                <a class="mr-2" href="submit">
                    <i class="mdi mdi-star-outline" id="review" aria-hidden="true"></i> Write a review</a>
                <a class="btn btn-sm my-2 my-sm-0" data-toggle="modal" data-target="#loginModal">
                    Login
                </a>
                <a class="btn btn-sm my-2 my-sm-0 mr-2 loginbtn" href="sign_up.php">Join</a>
            </div>
        </div>
    </div>
</nav>

<div class="container">
    <div class="row">
        <div class="col-lg-12 border-bottom mb-4">
            <h4 class="h2 text-center mb-0">Classic Florida Clubhouse Wedding <br><b>Megan & Loukas</b></h4>
            <p class="text-muted text-center mt-2">FEBRUARY 18 &bigodot;
                PONTE VEDRA BEACH, FLORIDA</p>
        </div>
        <div class="col-lg-8">
            <div class="card-columns">
                <div class="card">
                    <img class="card-img-top" style="border-radius: 0" src="images/wedding/400x400_1517899737711-tpc-sawgrass-1.jpg" alt="Card image cap">
                </div>
                <div class="card">
                    <img class="card-img-top" style="border-radius: 0" src="images/wedding/400x400_1517899737847-classic-florida-clubhouse-wedding.jpg" alt="Card image cap">
                </div>
                <div class="card">
                    <img class="card-img-top" style="border-radius: 0" src="images/wedding/400x400_1517899745077-tpc-sawgrass-2.jpg" alt="Card image cap">
                </div>
                <div class="card">
                    <img class="card-img-top" style="border-radius: 0" src="images/wedding/400x400_1517899751541-tpc-sawgrass-3.jpg" alt="Card image cap">
                </div>
                <div class="card">
                    <img class="card-img-top" style="border-radius: 0" src="images/wedding/400x400_1517899758000-tpc-sawgrass-4.jpg" alt="Card image cap">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899764506-tpc-sawgrass-5.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899771149-tpc-sawgrass-6.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899791955-tpc-sawgrass-9.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899797972-tpc-sawgrass-10.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899824701-tpc-sawgrass-11.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899824712-tpc-sawgrass-12.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899831834-tpc-sawgrass-13.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/wedding/400x400_1517899838618-tpc-sawgrass-14.jpg" alt="Card image">
                </div>
                <div class="card">
                    <img class="card-img" style="border-radius: 0" src="images/real-weddings/post12/220x220_SQ_1511906215469-star-hill-ranch-2.jpg" alt="Card image">
                </div>
            </div>
        </div>
        <div class="col-lg-4">
            <h5>About this gallery:</h5>
            <p class="font-weight-bold mb-0 mt-0">Megan & Loukas </p>
            <p class="mb-0">February 18</p>
            <p>Ponte Vedra Beach, Florida</p>

            <h5>Vendors:</h5>
            <p>Megan and Loukas were married at TPC Sawgrass in Ponte Vedra Beach, Florida on February 18.</p>
            <p>Venue: TPC Sawgrass</p>
            <p>Planner: Uncorked Occasions</p>
            <p>Bride's Dress: Allure Bridals</p>
            <p>Bride's Shoes: Jimmy Choo</p>
            <p>Bridesmaid Dresses: Lulu's Bridal</p>
            <p>Groom's Attire: Tom James</p>
            <p>Groomsmen Attire: Vera Wang</p>
            <p>Hair Stylist: STUDIO BRIDE Makeup & Hair</p>
            <p>Makeup Artist:STUDIO BRIDE Makeup & Hair</p>
            <p>Invitations: Paper Doll</p>
            <p>Officiant: Father Michael Houle</p>
            <p>Floral Design: Rose of Sharon European Florist</p>
            <p>Reception Entertainment: Sounds of Grace</p>
            <p>Catering: TPC Sawgrass</p>
            <p>Baker: Classic Cakes</p>
            <p>Videography: CollabCreation Films</p>
            <p>Transportation: Golden Hinde Limousine Service</p>
        </div>


    </div>
</div>
<!-- MODAL LOGIN SECTION-->
<div class="modal fade" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="loginModal" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="loginModal"><img src="images/logo/MOMMYAMBOL.png" alt=""></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="register.php" method="post">
                    <div class="form-group row">
                        <label for="inputEmail" class="col-sm-2 col-form-label">Email:</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" id="inputEmail" name="email"
                                   placeholder="Enter email">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="inputPassword" class="col-sm-2 col-form-label">Password:</label>
                        <div class="col-sm-10">
                            <input type="password" class="form-control" id="inputPassword" placeholder="Enter password">
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="login" class="col-sm-2 col-form-label"></label>
                        <div class="col-sm-10">
                            <button type="button" class="btn btn-primary mr-2 custom-btn" style="font-size: 14px;">
                                Login
                            </button>
                            <a href="" style="color: #22adb5;">Forgot your password?</a>
                            <br/>
                            <div class="mt-2">Not a member yet? <a href="" style="color: #22adb5;">Join Now</a></div
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Optional JavaScript -->
<!-- jQuery first, then Popper.js, then Bootstrap JS -->
<script src="js/jquery-3.2.1.slim.min.js"></script>
<script src="js/jquery.min.js"></script>
<script src="js/popper.min.js"></script>
<script src="js/bootstrap.min.js"></script>
</body>
</html>