<?php
if(isset($_GET['id']) && $_GET['id'] > 0){
    $qry = $conn->query("SELECT * from `cargo_list` where id = '{$_GET['id']}' ");
    if($qry->num_rows > 0){
        foreach($qry->fetch_assoc() as $k => $v){
            $$k=$v;
        }
        if(isset($id)){
            $meta_qry = $conn->query("SELECT * FROM `cargo_meta` where cargo_id = '{$id}'");
            while($row = $meta_qry->fetch_assoc()){
                ${$row['meta_field']} = $row['meta_value'];
            }
        }
    }
}

$cargo_type = [];
$cargo_type_qry = $conn->query("SELECT id,`name`, city_price, state_price, country_price FROM `cargo_type_list` where delete_flag = 0 order by `name` asc");
while($row = $cargo_type_qry->fetch_assoc()){
    $cargo_type[$row['id']] = $row;
}
?>

<div class="content py-3">

<!-- PAGE HEADER -->
<div class="d-flex align-items-center justify-content-between mb-3">
    <h4 class="mb-0 font-weight-semibold">
        <i class="fas fa-shipping-fast text-primary mr-2"></i>
        <?= isset($id) ? "Update Transaction" : "New Transaction" ?>
    </h4>
    <a href="./?route=transactions" class="btn btn-sm btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Back
    </a>
</div>

<div class="card transaction-card shadow-sm">
    <form id="cargo-form">
    <input type="hidden" name="id" value="<?= isset($id) ? $id : '' ?>">

    <div class="card-body">

    <!-- SENDER & RECEIVER -->
    <div class="row">
        <div class="col-md-6">
            <div class="card section-card">
                <div class="card-header">
                    <i class="fas fa-user text-primary mr-2"></i> Sender Information
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" name="sender_name" class="form-control" value="<?= $sender_name ?? '' ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Contact</label>
                        <input type="text" name="sender_contact" class="form-control" value="<?= $sender_contact ?? '' ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <textarea name="sender_address" rows="3" class="form-control" required><?= $sender_address ?? '' ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="card section-card">
                <div class="card-header">
                    <i class="fas fa-user-check text-success mr-2"></i> Receiver Information
                </div>
                <div class="card-body">
                    <div class="form-group">
                        <label>Full Name</label>
                        <input type="text" name="receiver_name" class="form-control" value="<?= $receiver_name ?? '' ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Contact</label>
                        <input type="text" name="receiver_contact" class="form-control" value="<?= $receiver_contact ?? '' ?>" required>
                    </div>
                    <div class="form-group">
                        <label>Address</label>
                        <textarea name="receiver_address" rows="3" class="form-control" required><?= $receiver_address ?? '' ?></textarea>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- LOCATION & SHIPPING -->
    <div class="card section-card">
        <div class="card-body row">
            <div class="col-md-6">
                <label>From Location</label>
                <textarea name="from_location" class="form-control" rows="3" required><?= $from_location ?? '' ?></textarea>
            </div>
            <div class="col-md-6">
                <label>To Location</label>
                <textarea name="to_location" class="form-control" rows="3" required><?= $to_location ?? '' ?></textarea>
            </div>
            <div class="col-md-6 mt-2">
                <label>Shipping Type</label>
                <select name="shipping_type" id="shipping_type" class="form-control" required>
                    <option value="1" <?= ($shipping_type ?? '') == 1 ? 'selected':'' ?>>City to City</option>
                    <option value="2" <?= ($shipping_type ?? '') == 2 ? 'selected':'' ?>>State to State</option>
                    <option value="3" <?= ($shipping_type ?? '') == 3 ? 'selected':'' ?>>Country to Country</option>
                </select>
            </div>
        </div>
    </div>

    <!-- CARGO ITEMS -->
    <div class="card section-card">
        <div class="card-header">
            <i class="fas fa-boxes mr-2"></i> Cargo Items
        </div>
        <div class="card-body">

            <div class="cargo-table-header">
                <div>Cargo Type</div>
                <div class="text-right">Price</div>
                <div class="text-center">Weight (kg)</div>
                <div class="text-right">Total</div>
            </div>

           <div id="cargo-item-list" class="cargo-table-body">

<?php if(isset($id)): ?>
<?php
$items = $conn->query("
    SELECT i.*, t.name 
    FROM cargo_items i 
    INNER JOIN cargo_type_list t ON i.cargo_type_id = t.id 
    WHERE i.cargo_id = '{$id}'
");
while($row = $items->fetch_assoc()):
?>
<div class="cargo-item">
    <div>
        <input type="hidden" name="price[]" value="<?= $row['price'] ?>">
        <input type="hidden" name="total[]" value="<?= $row['total'] ?>">
        <select name="cargo_type_id[]" class="form-control select2">
            <?php foreach($cargo_type as $ct): ?>
                <option value="<?= $ct['id'] ?>"
                    <?= $ct['id'] == $row['cargo_type_id'] ? 'selected':'' ?>>
                    <?= $ct['name'] ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="text-right font-weight-bold price">
        <?= number_format($row['price'],2) ?>
    </div>
    <div>
        <input type="number" step="any" name="weight[]" class="form-control text-right"
               value="<?= $row['weight'] ?>">
    </div>
    <div class="text-right font-weight-bold total">
        <?= number_format($row['total'],2) ?>
    </div>
</div>
<?php endwhile; ?>
<?php endif; ?>

</div>

            <div class="cargo-grand-total">
                <span>Grand Total</span>
                <strong id="gtotal">0.00</strong>
                <input type="hidden" name="total_amount">
            </div>

            <div class="text-right mt-2">
                <button type="button" class="btn btn-outline-primary btn-sm" id="add_item">
                    <i class="fa fa-plus"></i> Add Item
                </button>
            </div>

        </div>
    </div>

    </div>

    <div class="card-footer text-right bg-white">
        <button class="btn btn-primary px-4" type="submit">
            <i class="fas fa-save mr-1"></i> Save
        </button>
        <a href="./?route=transactions" class="btn btn-outline-secondary px-4">Cancel</a>
    </div>

    </form>
</div>
</div>

<!-- ITEM TEMPLATE -->
<noscript id="cargo-item-clone">
<div class="cargo-item">
    <div>
        <input type="hidden" name="price[]">
        <input type="hidden" name="total[]">
        <select name="cargo_type_id[]" class="form-control select2">
            <option disabled selected>Select Cargo</option>
            <?php foreach($cargo_type as $row): ?>
                <option value="<?= $row['id'] ?>"><?= $row['name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="text-right font-weight-bold price">0.00</div>
    <div><input type="number" step="any" name="weight[]" class="form-control text-right"></div>
    <div class="text-right font-weight-bold total">0.00</div>
</div>
</noscript>
<script>
const cargo_type = $.parseJSON('<?= json_encode($cargo_type) ?>');

function change_price(row, cargo_type_id){
    let type = $('#shipping_type').val();
    let price = 0;

    if(cargo_type[cargo_type_id]){
        if(type == 1){
            price = cargo_type[cargo_type_id].city_price;
        }else if(type == 2){
            price = cargo_type[cargo_type_id].state_price;
        }else if(type == 3){
            price = cargo_type[cargo_type_id].country_price;
        }
    }

    row.find("input[name='price[]']").val(price);
    row.find(".price").text(parseFloat(price).toLocaleString("en-US"));
    calc();
}

function calc(){
    let gtotal = 0;

    $('#cargo-item-list .cargo-item').each(function(){
        let price = parseFloat($(this).find('[name="price[]"]').val()) || 0;
        let weight = parseFloat($(this).find('[name="weight[]"]').val()) || 0;
        let total = price * weight;

        $(this).find('[name="total[]"]').val(total);
        $(this).find('.total').text(total.toLocaleString('en-US'));

        gtotal += total;
    });

    $('[name="total_amount"]').val(gtotal);
    $('#gtotal').text(gtotal.toLocaleString('en-US'));
}

function bindItemEvents(item){
    item.find("[name='cargo_type_id[]']").on('change', function(){
        change_price(item, $(this).val());
    });

    item.find('[name="weight[]"]').on('input', function(){
        calc();
    });
}

$(document).ready(function(){

    // Init select2
    $('.select2').select2({
        width:"100%",
        placeholder:"Please Select Here"
    });

    // Bind events for EXISTING items (EDIT MODE)
    $('#cargo-item-list .cargo-item').each(function(){
        bindItemEvents($(this));
    });

    // Add new item
    $('#add_item').click(function(){
        let item = $($('#cargo-item-clone').html()).clone();
        $('#cargo-item-list').append(item);

        item.find('.select2').select2({
            width:"100%",
            placeholder:"Please Select Here"
        });

        bindItemEvents(item);
    });

    // Shipping type change (recalculate all)
    $('#shipping_type').change(function(){
        $('#cargo-item-list .cargo-item').each(function(){
            let id = $(this).find('[name="cargo_type_id[]"]').val();
            change_price($(this), id);
        });
    });

    // Initial total calculation on edit
    calc();

    // Submit form
    $('#cargo-form').submit(function(e){
        e.preventDefault();
        let _this = $(this);
        $('.err-msg').remove();
        start_loader();

        $.ajax({
            url:_base_url_+"classes/Master.php?f=save_cargo",
            data: new FormData(this),
            cache: false,
            contentType: false,
            processData: false,
            method: 'POST',
            dataType: 'json',
            error: err => {
                console.log(err);
                alert_toast("An error occurred",'error');
                end_loader();
            },
            success: function(resp){
                if(resp.status === 'success'){
                    location.replace("./?route=transactions/view_transaction&id="+resp.cid);
                }else if(resp.status === 'failed' && resp.msg){
                    let el = $('<div class="alert alert-danger err-msg">').text(resp.msg);
                    _this.prepend(el);
                    $("html, body").animate({ scrollTop: _this.closest('.card').offset().top }, "fast");
                }else{
                    alert_toast("An error occurred",'error');
                    console.log(resp);
                }
                end_loader();
            }
        });
    });

});
</script>