<?php
/* =========================
   FILTER INPUTS
========================= */
$status_filter = isset($_GET['status']) ? $_GET['status'] : '';
$from_date = isset($_GET['from_date']) ? $_GET['from_date'] : '';
$to_date   = isset($_GET['to_date']) ? $_GET['to_date'] : '';

$where = " WHERE 1=1 ";

if ($status_filter !== '') {
    $where .= " AND status = '" . $conn->real_escape_string($status_filter) . "'";
}

if ($from_date && $to_date) {
    $where .= " AND DATE(date_updated) BETWEEN '$from_date' AND '$to_date'";
}

/* =========================
   STATUS DEFINITIONS
========================= */
$status_labels = [
    0 => 'Pending',
    1 => 'In-Transit',
    2 => 'At Station',
    3 => 'Out for Delivery',
    4 => 'Delivered'
];

/* =========================
   SUMMARY COUNTS
========================= */
$summary = [];
foreach ($status_labels as $key => $label) {
    $row = $conn->query("
        SELECT COUNT(*) AS total 
        FROM cargo_list 
        WHERE status = $key
    ")->fetch_assoc();
    $summary[$key] = $row['total'];
}

/* =========================
   FETCH REPORT DATA
========================= */
$report_sql = "
    SELECT *
    FROM cargo_list
    $where
    ORDER BY date_updated DESC
";

$report_data = $conn->query($report_sql);
?>

<!-- =========================
     PAGE HEADER
========================= -->
<div class="container-fluid mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3 class="fw-bold">
            <i class="fas fa-file-alt me-2"></i>Cargo Status Report
        </h3>
        <span class="text-muted">
            Generated on <?php echo date('M d, Y h:i A'); ?>
        </span>
    </div>

    <!-- =========================
         FILTER FORM
    ========================= -->
    <form method="GET" class="card shadow-sm p-3 mb-4 border-0 rounded-3">
        <div class="row g-3 align-items-end">

            <div class="col-md-3">
                <label class="form-label fw-semibold">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <?php foreach ($status_labels as $key => $label): ?>
                        <option value="<?php echo $key; ?>" <?php if ($status_filter === (string)$key) echo 'selected'; ?>>
                            <?php echo $label; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-3">
                <label class="form-label fw-semibold">From Date</label>
                <input type="date" name="from_date" value="<?php echo $from_date; ?>" class="form-control">
            </div>

            <div class="col-md-3">
                <label class="form-label fw-semibold">To Date</label>
                <input type="date" name="to_date" value="<?php echo $to_date; ?>" class="form-control">
            </div>

            <div class="col-md-3 d-flex gap-2">
                <button class="btn btn-primary w-100">
                    <i class="fas fa-filter me-1"></i>Apply
                </button>
                <a href="cargo_report.php" class="btn btn-outline-secondary w-100">
                    Reset
                </a>
            </div>

        </div>
    </form>

    <!-- =========================
         SUMMARY CARDS
    ========================= -->
    <div class="row g-3 mb-4">
        <?php foreach ($status_labels as $key => $label): ?>
        <div class="col-6 col-md-2">
            <div class="card text-center shadow-sm border-0 rounded-3">
                <div class="card-body">
                    <h6 class="text-muted mb-1"><?php echo $label; ?></h6>
                    <h3 class="fw-bold mb-0"><?php echo format_num($summary[$key]); ?></h3>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>

    <!-- =========================
         REPORT TABLE
    ========================= -->
    <div class="card shadow-sm border-0 rounded-3">
        <div class="card-body table-responsive">

            <table class="table table-hover align-middle">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Cargo Code</th>
                        <th>Status</th>
                        <th>Last Updated</th>
                    </tr>
                </thead>
                <tbody>
                <?php if ($report_data->num_rows > 0): 
                    $i = 1;
                    while ($row = $report_data->fetch_assoc()):
                ?>
                    <tr>
                        <td><?php echo $i++; ?></td>
                        <td>
                            <strong><?php echo htmlspecialchars($row['ref_code'] ?? '-'); ?></strong>
                        </td>
                        <td>
                            <span class="badge bg-secondary">
                                <?php echo $status_labels[$row['status']] ?? 'Unknown'; ?>
                            </span>
                        </td>
                        <td>
                            <?php echo date('M d, Y h:i A', strtotime($row['date_updated'])); ?>
                        </td>
                    </tr>
                <?php endwhile; else: ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">
                            No records found
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

        </div>
    </div>

</div>

<!-- =========================
     PAGE CSS
========================= -->
<style>
.table td, .table th {
    vertical-align: middle;
}
</style>
