<?php require_once('../config.php') ?>
<!DOCTYPE html>
<html lang="en" class="h-100">
<?php require_once('inc/header.php') ?>
<style>
:root {
  --primary-color: #4361ee;
  --secondary-color: #3a0ca3;
  --accent-color: #4cc9f0;
  --light-bg: rgba(255, 255, 255, 0.95);
}

* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
}

body {
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  min-height: 100vh;
  display: flex;
  align-items: center;
  justify-content: center;
  background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
  padding: 20px;
}

.login-container {
  display: flex;
  max-width: 450px;
  width: 100%;
  border-radius: 20px;
  overflow: hidden;
  box-shadow: 0 15px 50px rgba(0, 0, 0, 0.2);
  min-height: 350px;
  background: var(--light-bg);
  backdrop-filter: blur(10px);
  flex-direction: column;
  animation: fadeIn 0.8s ease-out;
}

.login-box {
  max-width: 400px;
  margin: 0 auto;
  width: 100%;
  padding: 40px 30px;
}

.login-header {
  text-align: center;
  margin-bottom: 40px;
}

.login-title {
  font-size: 2em;
  color: var(--secondary-color);
  margin-bottom: 10px;
  font-weight: 600;
}

.login-subtitle {
  color: #666;
  font-size: 1.1em;
}

.form-group {
  margin-bottom: 25px;
  position: relative;
}

.input-with-icon {
  position: relative;
}

.input-with-icon i {
  position: absolute;
  left: 20px;
  top: 50%;
  transform: translateY(-50%);
  color: #777;
  z-index: 2;
}

.form-control {
  width: 100%;
  padding: 18px 20px 18px 55px;
  border: 2px solid #e1e5ee;
  border-radius: 12px;
  font-size: 16px;
  transition: all 0.3s ease;
  background: white;
}

.form-control:focus {
  outline: none;
  border-color: var(--primary-color);
  box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.1);
}

.form-control::placeholder {
  color: #999;
}

.login-btn {
  background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
  color: white;
  border: none;
  padding: 18px;
  border-radius: 12px;
  font-size: 16px;
  font-weight: 600;
  cursor: pointer;
  transition: all 0.3s ease;
  width: 100%;
  margin-top: 10px;
}

.login-btn:hover {
  transform: translateY(-2px);
  box-shadow: 0 10px 25px rgba(67, 97, 238, 0.3);
}

.login-btn:active {
  transform: translateY(0);
}

.additional-links {
  margin-top: 30px;
  text-align: center;
}

.website-link {
  display: inline-flex;
  align-items: center;
  color: var(--primary-color);
  text-decoration: none;
  font-weight: 500;
  transition: color 0.3s ease;
}

.website-link:hover {
  color: var(--secondary-color);
}

.website-link i {
  margin-right: 8px;
}

.copyright {
  text-align: center;
  margin-top: 40px;
  color: #888;
  font-size: 0.9em;
}

@keyframes fadeIn {
  from {opacity: 0; transform: translateY(20px);}
  to {opacity: 1; transform: translateY(0);}
}

.pulse {
  animation: pulse 2s infinite;
}

@keyframes pulse {
  0% { box-shadow: 0 0 0 0 rgba(67, 97, 238, 0.4); }
  70% { box-shadow: 0 0 0 10px rgba(67, 97, 238, 0); }
  100% { box-shadow: 0 0 0 0 rgba(67, 97, 238, 0); }
}

.input-with-icon.focused i {
  color: var(--primary-color);
  transform: translateY(-50%) scale(1.1);
  transition: all 0.3s ease;
}

.input-with-icon.focused .form-control {
  border-color: var(--primary-color);
}
</style>
<body>
  <div class="login-container">
    <div class="login-box">
      <div class="login-header">
        <h2 class="login-title"><?php echo $_settings->info('name') ?></h2>
        <p class="login-subtitle">Enter your credentials to continue</p>
      </div>
      <form id="login-frm" action="" method="post">
        <div class="form-group input-with-icon">
          <i class="fas fa-user"></i>
          <input type="text" class="form-control" name="username" autofocus placeholder="Username or Email" required>
        </div>
        <div class="form-group input-with-icon">
          <i class="fas fa-lock"></i>
          <input type="password" class="form-control" name="password" placeholder="Password" required>
        </div>
        <div class="form-group">
          <button type="submit" class="login-btn pulse">Sign In <i class="fas fa-arrow-right ml-2"></i></button>
        </div>
        <div class="additional-links">
          <a href="<?php echo base_url ?>" class="website-link">
            <i class="fas fa-external-link-alt"></i> Go to Main Website
          </a>
        </div>
      </form>
      <div class="copyright">
        &copy; <?php echo date('Y'); ?> <?php echo $_settings->info('name') ?>. All rights reserved.
      </div>
    </div>
  </div>

  <!-- Scripts -->
  <script src="plugins/jquery/jquery.min.js"></script>
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
  <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
  <script>
    $(document).ready(function(){
      // Focus/blur animation
      $('.form-control').focus(function(){
        $(this).parent().addClass('focused');
      }).blur(function(){
        $(this).parent().removeClass('focused');
      });
    });
  </script>
</body>
</html>