<?php
// dashboard.php - Premium Dashboard Page

/* =======================
   BASIC COUNTS
======================= */
$cargo_total = $conn->query("SELECT * FROM cargo_list")->num_rows;
$cargo_type_count = $conn->query("SELECT * FROM cargo_type_list WHERE delete_flag = 0")->num_rows;

/* =======================
   OVERALL LAST UPDATE
======================= */
$last_update_row = $conn->query("
    SELECT MAX(date_updated) AS last_updated 
    FROM cargo_list
")->fetch_assoc();

$last_updated = $last_update_row['last_updated']
    ? date('M d, Y h:i A', strtotime($last_update_row['last_updated']))
    : 'No updates';

/* =======================
   STATUS CARD CONFIG
======================= */
$status_cards = [
    ['status' => 0, 'title' => 'Pending', 'icon' => 'fas fa-clock', 'color' => 'warning'],
    ['status' => 1, 'title' => 'In-Transit', 'icon' => 'fas fa-shipping-fast', 'color' => 'info'],
    ['status' => 2, 'title' => 'At Station', 'icon' => 'fas fa-warehouse', 'color' => 'primary'],
    ['status' => 3, 'title' => 'Out for Delivery', 'icon' => 'fas fa-truck', 'color' => 'secondary'],
    ['status' => 4, 'title' => 'Delivered', 'icon' => 'fas fa-check-circle', 'color' => 'success'],
];
?>

<!-- =======================
     DASHBOARD HEADER
======================= -->
<div class="dashboard-header mb-4 p-4 rounded-3 shadow-sm d-flex justify-content-between align-items-center flex-wrap"
     style="background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);">

    <div>
        <h1 class="display-6 fw-bold text-gradient-primary mb-1">
            Welcome to <?php echo $_settings->info('name') ?>
        </h1>
        <p class="text-muted mb-0">
            Here's what's happening with your cargo shipments today
        </p>
    </div>

    <div class="dashboard-date mt-2 mt-md-0">
        <div class="date-badge">
            <i class="fas fa-calendar-alt me-2"></i>
            <?php echo date('F j, Y'); ?>
        </div>
    </div>
</div>

<!-- =======================
     KPI + STATUS CARDS
======================= -->
<div class="row g-4">

    <!-- TOTAL CARGO TYPES -->
    <div class="col-12 col-md-4">
        <div class="card kpi-card shadow-sm border-0 hover-lift p-3 rounded-3">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="kpi-icon bg-gradient-primary rounded-circle mb-3">
                        <i class="fas fa-layer-group"></i>
                    </div>

                    <h6 class="text-uppercase text-muted">Total Cargo Types</h6>
                    <h2 class="fw-bold mb-1"><?php echo format_num($cargo_type_count); ?></h2>

                    <span class="text-muted small">
                        <i class="fas fa-clock me-1"></i>
                        Updated <?php echo $last_updated; ?>
                    </span>
                </div>

                <div class="dropdown">
                    <button class="btn btn-link text-muted p-0" data-bs-toggle="dropdown">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-eye me-2"></i>View Details</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-chart-line me-2"></i>Analytics</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <!-- STATUS CARDS -->
    <?php foreach ($status_cards as $card): 

        $count = $conn->query("
            SELECT id FROM cargo_list 
            WHERE status = {$card['status']}
        ")->num_rows;

        $updated_row = $conn->query("
            SELECT MAX(date_updated) AS last_updated 
            FROM cargo_list 
            WHERE status = {$card['status']}
        ")->fetch_assoc();

        $card_updated = $updated_row['last_updated']
            ? date('M d, Y h:i A', strtotime($updated_row['last_updated']))
            : 'No updates';
    ?>
    <div class="col-12 col-md-4">
        <div class="card kpi-card shadow-sm border-0 hover-lift p-3 rounded-3">
            <div class="d-flex justify-content-between align-items-start">
                <div>
                    <div class="kpi-icon bg-<?php echo $card['color']; ?> rounded-circle mb-3">
                        <i class="<?php echo $card['icon']; ?>"></i>
                    </div>

                    <h6 class="text-uppercase text-muted"><?php echo $card['title']; ?></h6>
                    <h2 class="fw-bold mb-1"><?php echo format_num($count); ?></h2>

                    <span class="text-muted small">
                        <i class="fas fa-clock me-1"></i>
                        Updated <?php echo $card_updated; ?>
                    </span>
                </div>

                <div class="dropdown">
                    <button class="btn btn-link text-muted p-0" data-bs-toggle="dropdown">
                        <i class="fas fa-ellipsis-v"></i>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a class="dropdown-item" href="#"><i class="fas fa-eye me-2"></i>View Details</a></li>
                        <li><a class="dropdown-item" href="#"><i class="fas fa-chart-line me-2"></i>Analytics</a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <?php endforeach; ?>

</div>

<!-- =======================
     CUSTOM CSS
======================= -->
<style>
.text-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.kpi-card {
    transition: all 0.3s ease;
}

.kpi-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1);
}

.kpi-icon {
    width: 60px;
    height: 60px;
    display: flex;
    justify-content: center;
    align-items: center;
    font-size: 1.5rem;
    color: #fff;
}

.kpi-icon.bg-warning { background: linear-gradient(135deg, #f6d365 0%, #fda085 100%); }
.kpi-icon.bg-info { background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%); }
.kpi-icon.bg-primary { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
.kpi-icon.bg-secondary { background: linear-gradient(135deg, #6c757d 0%, #495057 100%); }
.kpi-icon.bg-success { background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%); }

.date-badge {
    background: #fff;
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-weight: 500;
    box-shadow: 0 3px 10px rgba(0,0,0,0.08);
}
</style>