<!-- Back to Top Button -->
<a href="#" class="back-to-top" id="backToTop">
    <i class="fas fa-chevron-up"></i>
</a>

<!-- Footer -->
<footer class="footer-main pt-5">
    <div class="container position-relative">
        <div class="row g-5">
            <!-- Company Info -->
            <div class="col-lg-4">
                <a href="<?php echo base_url ?>" class="footer-logo d-block mb-4">
                    <?php echo $_settings->info('short_name') ?>
                </a>
                <p class="text-white-50 mb-4">
                    Leading air cargo management and tracking solutions with 
                    real-time visibility and enterprise-grade security for 
                    global logistics operations.
                </p>
                <div class="social-links">
                    <a href="#" class="social-link" title="Facebook">
                        <i class="fab fa-facebook-f"></i>
                    </a>
                    <a href="#" class="social-link" title="Twitter">
                        <i class="fab fa-twitter"></i>
                    </a>
                    <a href="#" class="social-link" title="LinkedIn">
                        <i class="fab fa-linkedin-in"></i>
                    </a>
                    <a href="#" class="social-link" title="Instagram">
                        <i class="fab fa-instagram"></i>
                    </a>
                    <a href="#" class="social-link" title="YouTube">
                        <i class="fab fa-youtube"></i>
                    </a>
                </div>
            </div>

            <!-- Quick Links -->
            <div class="col-lg-2 col-md-4">
                <h5 class="footer-heading">Quick Links</h5>
                <ul class="footer-links">
                    <li><a href="<?php echo base_url ?>">
                        <i class="fas fa-home"></i> Home
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-info-circle"></i> About Us
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-concierge-bell"></i> Services
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-shipping-fast"></i> Track Shipment
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-phone-alt"></i> Contact Us
                    </a></li>
                </ul>
            </div>

            <!-- Our Services -->
            <div class="col-lg-2 col-md-4">
                <h5 class="footer-heading">Our Services</h5>
                <ul class="footer-links">
                    <li><a href="#">
                        <i class="fas fa-plane-departure"></i> Air Freight
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-ship"></i> Ocean Freight
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-truck"></i> Road Transportation
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-warehouse"></i> Warehousing
                    </a></li>
                    <li><a href="#">
                        <i class="fas fa-box-open"></i> Customs Clearance
                    </a></li>
                </ul>
            </div>

            <!-- Contact & Newsletter -->
            <div class="col-lg-4 col-md-8">
                <h5 class="footer-heading">Contact Info</h5>
                <div class="contact-info">
                    <div>
                        <i class="fas fa-map-marker-alt"></i>
                        <span>
                            <?php echo $_settings->info('address') ?: '123 Airport Blvd, Cargo City<br>International Airport, 10001' ?>
                        </span>
                    </div>
                    <div>
                        <i class="fas fa-phone"></i>
                        <span><?php echo $_settings->info('contact') ?: '+1 (555) 123-4567' ?></span>
                    </div>
                    <div>
                        <i class="fas fa-envelope"></i>
                        <span><?php echo $_settings->info('email') ?: 'info@aircargo.com' ?></span>
                    </div>
                    <div>
                        <i class="fas fa-clock"></i>
                        <span>24/7 Customer Support</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer Bottom -->
        <div class="footer-bottom pt-4">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <p class="copyright mb-0">
                        Copyright &copy; <?php echo date('Y') ?> 
                        <a href="<?php echo base_url ?>"><?php echo $_settings->info('short_name') ?></a>. 
                        All rights reserved.
                    </p>
                </div>
                <div class="col-md-6">
                    <ul class="footer-legal-links">
                        <li>
                            <a href="javascript:void(0)" id="p_use">
                                Privacy Policy
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo base_url ?>terms.php">
                                Terms of Service
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo base_url ?>sitemap.php">
                                Sitemap
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo base_url ?>cookies.php">
                                Cookies
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</footer>

<script>
$(document).ready(function(){
    // Privacy Policy Modal
    $('#p_use').click(function(){
        uni_modal("Privacy Policy","policy.php","modal-lg")
    });
    
    // Back to Top Button
    $(window).scroll(function() {
        if ($(this).scrollTop() > 300) {
            $('#backToTop').addClass('visible');
        } else {
            $('#backToTop').removeClass('visible');
        }
    });
    
    $('#backToTop').click(function(e) {
        e.preventDefault();
        $('html, body').animate({scrollTop: 0}, 600, 'easeInOutExpo');
        return false;
    });
    
    // Smooth scroll for anchor links in footer
    $('footer a[href^="#"]').click(function(e) {
        const target = $(this.getAttribute('href'));
        if (target.length) {
            e.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 80
            }, 1000, 'easeInOutExpo');
        }
    });
    
    // Enhanced modal functions
    window.viewer_modal = function($src = ''){
        start_loader();
        var t = $src.split('.');
        t = t[1];
        
        var modalContent = $('#viewer_modal .modal-content');
        modalContent.find('video, img').remove();
        
        if(t === 'mp4'){
            var view = $(`<video src="${$src}" controls autoplay class="w-100 rounded"></video>`);
        } else {
            var view = $(`<img src="${$src}" class="img-fluid rounded">`);
        }
        
        modalContent.append(view);
        $('#viewer_modal').modal({
            show: true,
            backdrop: 'static',
            keyboard: false,
            focus: true
        });
        end_loader();
    };
    
    window.uni_modal = function($title = '', $url = '', $size = ""){
        start_loader();
        $.ajax({
            url: $url,
            method: 'GET',
            dataType: 'html',
            error: function(err){
                console.error(err);
                uni_modal_notify('Error', 'An error occurred while loading the content.', 'error');
            },
            success: function(resp){
                if(resp){
                    const $modal = $('#uni_modal');
                    $modal.find('.modal-title').html($title);
                    $modal.find('.modal-body').html(resp);
                    
                    const $dialog = $modal.find('.modal-dialog');
                    $dialog.removeClass().addClass('modal-dialog modal-dialog-centered');
                    
                    if($size){
                        $dialog.addClass($size);
                    }
                    
                    $modal.modal({
                        show: true,
                        backdrop: 'static',
                        keyboard: false,
                        focus: true
                    });
                    
                    // Add custom modal styling
                    $modal.on('shown.bs.modal', function(){
                        $modal.find('.modal-content').addClass('border-0 shadow-lg');
                    });
                    
                    end_loader();
                }
            }
        });
    };
    
    window._conf = function($msg = '', $func = '', $params = []){
        const $modal = $('#confirm_modal');
        const $confirmBtn = $modal.find('#confirm');
        
        // Clear previous listeners
        $confirmBtn.off('click');
        
        // Add new listener
        $confirmBtn.on('click', function(){
            eval($func + '(' + $params.join(',') + ')');
            $modal.modal('hide');
        });
        
        $modal.find('.modal-body').html($msg);
        $modal.modal('show');
    };
    
    // Notification function for modal errors
    window.uni_modal_notify = function(title, message, type = 'info') {
        const icon = {
            'error': 'fas fa-exclamation-circle text-danger',
            'success': 'fas fa-check-circle text-success',
            'info': 'fas fa-info-circle text-info',
            'warning': 'fas fa-exclamation-triangle text-warning'
        }[type] || 'fas fa-info-circle text-info';
        
        uni_modal(title, `
            <div class="text-center py-4">
                <i class="${icon} fa-3x mb-3"></i>
                <h4 class="mb-3">${title}</h4>
                <p class="text-muted">${message}</p>
                <button class="btn btn-primary mt-3" data-bs-dismiss="modal">Close</button>
            </div>
        `, 'modal-sm');
    };
});

// Initialize tooltips for footer icons
$(function () {
    $('[title]').tooltip({
        trigger: 'hover',
        placement: 'top'
    });
});
</script>

<!-- Bootstrap 4 -->
<script src="<?php echo base_url ?>plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<!-- ChartJS -->
<script src="<?php echo base_url ?>plugins/chart.js/Chart.min.js"></script>
<!-- Sparkline -->
<script src="<?php echo base_url ?>plugins/sparklines/sparkline.js"></script>
<!-- Select2 -->
<script src="<?php echo base_url ?>plugins/select2/js/select2.full.min.js"></script>
<!-- JQVMap -->
<script src="<?php echo base_url ?>plugins/jqvmap/jquery.vmap.min.js"></script>
<script src="<?php echo base_url ?>plugins/jqvmap/maps/jquery.vmap.usa.js"></script>
<!-- jQuery Knob Chart -->
<script src="<?php echo base_url ?>plugins/jquery-knob/jquery.knob.min.js"></script>
<!-- daterangepicker -->
<script src="<?php echo base_url ?>plugins/moment/moment.min.js"></script>
<script src="<?php echo base_url ?>plugins/daterangepicker/daterangepicker.js"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="<?php echo base_url ?>plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
<!-- Summernote -->
<script src="<?php echo base_url ?>plugins/summernote/summernote-bs4.min.js"></script>
<!-- DataTables -->
<script src="<?php echo base_url ?>plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?php echo base_url ?>plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="<?php echo base_url ?>plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="<?php echo base_url ?>plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
<!-- AdminLTE -->
<script src="<?php echo base_url ?>dist/js/adminlte.js"></script>
<!-- Custom Easing -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.4.1/jquery.easing.min.js"></script>