<?php
$ref_code = $_GET['ref_code'] ?? null;
$cargo = null;

if ($ref_code) {
    $stmt = $conn->prepare("SELECT * FROM cargo_list WHERE ref_code = ?");
    $stmt->bind_param("s", $ref_code);
    $stmt->execute();
    $cargo = $stmt->get_result()->fetch_assoc();
}
?>

<section class="py-5">
    <div class="container">

        <!-- HERO SECTION -->
        <div class="hero mb-5">
            <div class="row align-items-center">
                <!-- LEFT: TEXT CONTENT -->
                <div class="col-lg-6 mb-4 mb-lg-0">
                    <div class="mb-4">
                        <span class="badge bg-white text-dark px-3 py-2 mb-3" style="border-radius: 50px;">
                            <i class="fas fa-plane-departure me-2"></i> Tracking System
                        </span>
                        <h1>Air Cargo Management System</h1>
                        <p class="mt-3">
                            Track, manage, and optimize your air freight operations
                            with real-time visibility and enterprise-grade security.
                        </p>
                    </div>
                    
                    <div class="d-flex gap-3 mt-4">
                        <div class="text-center">
                            <div class="display-6 fw-bold text-white">99.9%</div>
                            <div class="text-white-50 small">Uptime</div>
                        </div>
                        <div class="text-center">
                            <div class="display-6 fw-bold text-white">24/7</div>
                            <div class="text-white-50 small">Tracking</div>
                        </div>
                        <div class="text-center">
                            <div class="display-6 fw-bold text-white">150+</div>
                            <div class="text-white-50 small">Countries</div>
                        </div>
                    </div>
                </div>

                <!-- RIGHT: TRACKING FORM -->
                <div class="col-lg-6">
                    <div class="hero-trace">
                        <h4>
                            <i class="fas fa-search-location me-2"></i>
                            Trace Your Shipment
                        </h4>
                        
                        <form id="trace-frm">
                            <div class="row g-3 align-items-end">
                                <div class="col-md-8">
                                    <label>Shipment Reference Code</label>
                                    <input type="text"
                                           name="ref_code"
                                           class="form-control form-control-lg"
                                           placeholder="Enter Airway Bill / Reference No"
                                           value="<?= htmlspecialchars($ref_code ?? '') ?>"
                                           required>
                                </div>
                                <div class="col-md-4">
                                    <button type="submit" class="btn trace-btn btn-lg w-100 text-light">
                                       Track
                                    </button>
                                    <div class="loading-spinner mt-2"></div>
                                </div>
                            </div>
                        </form>

                        <div class="mt-4">
                            <small class="text-muted d-block">
                                <i class="fas fa-info-circle me-1"></i>
                                Enter your Airway Bill number or reference code
                            </small>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- TRACKING RESULTS -->
        <?php if ($ref_code): ?>
        <div class="tracking-result">
            <div class="row justify-content-center">
                <div class="col-lg-10">
                    <?php if ($cargo): ?>
                    <div class="card tracking-card">
                        <div class="card-body p-4 p-lg-5">
                            <div class="tracking-header d-flex align-items-start justify-content-between">
                                <div>
                                    <h4 class="mb-2">Shipment Tracking Result</h4>
                                    <div class="d-flex align-items-center gap-3">
                                        <div class="text-muted">
                                            <i class="fas fa-barcode me-1"></i>
                                            Reference: <strong><?= htmlspecialchars($cargo['ref_code']) ?></strong>
                                        </div>
                                        <div class="text-muted">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            Destination: <strong><?= htmlspecialchars($cargo['destination'] ?? 'N/A') ?></strong>
                                        </div>
                                        <span class="status-badge status-in-transit">
                                            <i class="fas fa-plane me-1"></i>In Transit
                                        </span>
                                    </div>
                                </div>
                            </div>

                            <div class="timeline-container">
                                <div class="timeline-track"></div>
                                <?php
                                $tracks = $conn->query("
                                    SELECT * FROM tracking_list
                                    WHERE cargo_id = '{$cargo['id']}'
                                    ORDER BY date_added DESC
                                ");
                                $first = true;
                                while ($row = $tracks->fetch_assoc()):
                                ?>
                                <div class="timeline-item <?= $first ? 'current' : '' ?>">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <h6><?= htmlspecialchars($row['title']) ?></h6>
                                        <small>
                                            <i class="far fa-clock me-1"></i>
                                            <?= date("F d, Y h:i A", strtotime($row['date_added'])) ?>
                                        </small>
                                    </div>
                                    <p class="mb-2"><?= nl2br(htmlspecialchars($row['description'])) ?></p>
                                    <?php if ($row['location']): ?>
                                    <small>
                                        <i class="fas fa-map-pin me-1"></i>
                                        <?= htmlspecialchars($row['location']) ?>
                                    </small>
                                    <?php endif; ?>
                                </div>
                                <?php $first = false; ?>
                                <?php endwhile; ?>
                            </div>

                            <div class="mt-4 pt-4 border-top">
                                <div class="row">
                                    <div class="col-md-4">
                                        <small class="text-muted">Estimated Delivery</small>
                                        <div class="fw-bold"><?= date("M d, Y", strtotime($cargo['estimated_delivery'] ?? '+7 days')) ?></div>
                                    </div>
                                    <div class="col-md-4">
                                        <small class="text-muted">Weight</small>
                                        <div class="fw-bold"><?= htmlspecialchars($cargo['weight'] ?? 'N/A') ?> kg</div>
                                    </div>
                                    <div class="col-md-4">
                                        <small class="text-muted">Dimensions</small>
                                        <div class="fw-bold"><?= htmlspecialchars($cargo['dimensions'] ?? 'N/A') ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php else: ?>
                    <div class="alert alert-warning shadow-sm">
                        <div class="d-flex align-items-center">
                            <i class="fas fa-exclamation-triangle fa-2x me-3"></i>
                            <div>
                                <h5 class="mb-1">Shipment Not Found</h5>
                                <p class="mb-0">Please check your reference code and try again.</p>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- FEATURES SECTION -->
        <div class="row g-4 mt-5 pt-4">
            <div class="col-md-4">
                <div class="card feature-card h-100">
                    <div class="card-body p-4">
                        <div class="feature-icon">
                            <i class="fas fa-satellite-dish"></i>
                        </div>
                        <h5 class="mb-3">Real-Time Tracking</h5>
                        <p>
                            Monitor shipments instantly using airway bill or
                            reference number with live updates and predictive analytics.
                        </p>
                        <a href="#" class="text-decoration-none small fw-bold">
                            Learn More <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card feature-card h-100">
                    <div class="card-body p-4">
                        <div class="feature-icon">
                            <i class="fas fa-plane"></i>
                        </div>
                        <h5 class="mb-3">Flight & Cargo Control</h5>
                        <p>
                            Manage flights, cargo loads, destinations, and schedules
                            efficiently from one dashboard with AI-powered insights.
                        </p>
                        <a href="#" class="text-decoration-none small fw-bold">
                            Learn More <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card feature-card h-100">
                    <div class="card-body p-4">
                        <div class="feature-icon">
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <h5 class="mb-3">Secure & Reliable</h5>
                        <p>
                            Role-based access, audit logs, and secure infrastructure
                            designed for enterprise air cargo operations.
                        </p>
                        <a href="#" class="text-decoration-none small fw-bold">
                            Learn More <i class="fas fa-arrow-right ms-1"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
          
        <div class="row g-4 mt-0 pt-4">
            <div class="card-body">
                <?= file_get_contents('welcome.html') ?>
            </div>
        </div>
    </div>
</section>

<script>
$(function () {
    // Form submission with loading animation
    $('#trace-frm').submit(function (e) {
        e.preventDefault();
        const ref = $('[name="ref_code"]').val().trim();
        if (ref !== '') {
            $('.trace-btn').prop('disabled', true);
            $('.loading-spinner').show();
            
            // Simulate loading for better UX
            setTimeout(() => {
                location.href = "./?ref_code=" + encodeURIComponent(ref);
            }, 800);
        }
    });

    // Auto-focus on input field
    $('[name="ref_code"]').focus();

    // Animate elements on scroll
    function animateOnScroll() {
        $('.feature-card').each(function () {
            const elementTop = $(this).offset().top;
            const elementBottom = elementTop + $(this).outerHeight();
            const viewportTop = $(window).scrollTop();
            const viewportBottom = viewportTop + $(window).height();
            
            if (elementBottom > viewportTop && elementTop < viewportBottom) {
                $(this).addClass('animated');
            }
        });
    }

    $(window).on('scroll', animateOnScroll);
    animateOnScroll(); // Initial check

    // Copy reference code to clipboard
    $(document).on('click', '.copy-ref', function() {
        const refCode = $(this).data('ref');
        navigator.clipboard.writeText(refCode).then(() => {
            const $btn = $(this);
            const originalText = $btn.html();
            $btn.html('<i class="fas fa-check"></i> Copied!');
            setTimeout(() => $btn.html(originalText), 2000);
        });
    });
});
</script>