<?php if($_settings->chk_flashdata('success')): ?>
<script>
	alert_toast("<?php echo $_settings->flashdata('success') ?>",'success')
</script>
<?php endif;?>

<style>
	img#cimg{
		height: 15vh;
		width: 15vh;
		object-fit: cover;
		border-radius: 100% 100%;
	}
	img#cimg2{
		height: 30vh;
		width: 100%;
		object-fit: contain;
	}
	.settings-container {
		display: flex;
		flex-wrap: wrap;
		gap: 20px;
	}
	.settings-column {
		flex: 1;
		min-width: 300px;
	}
	.settings-card {
		height: 100%;
	}
	.img-gallery {
		display: grid;
		grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
		gap: 10px;
		margin-top: 10px;
	}
	.img-item {
		position: relative;
	}
	.img-item img {
		width: 100%;
		height: 100px;
		object-fit: cover;
	}
	.img-item .btn-remove {
		position: absolute;
		top: 5px;
		right: 5px;
		width: 30px;
		height: 30px;
		padding: 0;
		display: flex;
		align-items: center;
		justify-content: center;
	}
	.form-section {
		margin-bottom: 25px;
		padding-bottom: 15px;
		border-bottom: 1px solid #dee2e6;
	}
	.form-section:last-child {
		border-bottom: none;
	}
	.form-section-title {
		font-size: 1.1rem;
		font-weight: 600;
		margin-bottom: 15px;
		color: #495057;
		padding-bottom: 8px;
		border-bottom: 2px solid #007bff;
	}
</style>

<div class="col-lg-12">
	<div class="card card-outline rounded-0 card-primary">
		<div class="card-header">
			<h5 class="card-title">System Settings</h5>
		</div>
		<div class="card-body">
			<form action="" id="system-frm">
				<div id="msg" class="form-group"></div>
				
				<div class="settings-container">
					<!-- Left Column -->
					<div class="settings-column">
						<div class="settings-card">
							<!-- System Information Section -->
							<div class="form-section">
								<div class="form-section-title">System Information</div>
								
								<div class="form-group">
									<label for="name" class="control-label">System Name</label>
									<input type="text" class="form-control form-control-sm" name="name" id="name" 
										   value="<?php echo $_settings->info('name') ?>">
								</div>
								
								<div class="form-group">
									<label for="short_name" class="control-label">System Short Name</label>
									<input type="text" class="form-control form-control-sm" name="short_name" id="short_name" 
										   value="<?php echo $_settings->info('short_name') ?>">
								</div>
							</div>
							
							<!-- System Logo Section -->
							<div class="form-section">
								<div class="form-section-title">System Logo</div>
								
								<div class="form-group">
									<label for="" class="control-label">Upload Logo</label>
									<div class="custom-file">
										<input type="file" class="custom-file-input rounded-circle" id="customFile" 
											   name="img" onchange="displayImg(this,$(this))">
										<label class="custom-file-label" for="customFile">Choose logo file</label>
									</div>
									<small class="text-muted">Recommended: Square image, 200x200px or larger</small>
								</div>
								
								<div class="form-group d-flex justify-content-center">
									<div class="text-center">
										<img src="<?php echo validate_image($_settings->info('logo')) ?>" 
											 alt="System Logo" id="cimg" class="img-fluid img-thumbnail">
										<div class="mt-2 text-muted">Current Logo</div>
									</div>
								</div>
							</div>
							
							<!-- Website Cover Section -->
							<div class="form-section">
								<div class="form-section-title">Website Cover</div>
								
								<div class="form-group">
									<label for="" class="control-label">Upload Cover Image</label>
									<div class="custom-file">
										<input type="file" class="custom-file-input rounded-circle" id="customFile" 
											   name="cover" onchange="displayImg2(this,$(this))">
										<label class="custom-file-label" for="customFile">Choose cover file</label>
									</div>
									<small class="text-muted">Recommended: 1200x400px or similar aspect ratio</small>
								</div>
								
								<div class="form-group d-flex justify-content-center">
									<div class="text-center w-100">
										<img src="<?php echo validate_image($_settings->info('cover')) ?>" 
											 alt="Website Cover" id="cimg2" class="img-fluid img-thumbnail">
										<div class="mt-2 text-muted">Current Cover</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					
					<!-- Right Column -->
					<div class="settings-column">
						<div class="settings-card">
							<!-- Banner Images Section -->
							<div class="form-section">
								<div class="form-section-title">Banner Images</div>
								
								<div class="form-group">
									<label for="" class="control-label">Upload New Banner Images</label>
									<div class="custom-file">
										<input type="file" class="custom-file-input rounded-circle" id="customFile" 
											   name="banners[]" multiple accept=".png,.jpg,.jpeg" 
											   onchange="displayImg3(this,$(this))">
										<label class="custom-file-label" for="customFile">Choose banner files</label>
									</div>
									<small class="text-muted"><i>You can select multiple images at once</i></small>
									<br>
									<small class="text-muted">Recommended: 1200x600px or similar aspect ratio</small>
								</div>
								
								<div class="current-banners mt-3">
									<label class="control-label">Current Banners</label>
									
									<?php 
									$upload_path = "uploads/banner";
									if(is_dir(base_app.$upload_path)): 
										$file= scandir(base_app.$upload_path);
										if(count($file) > 2): // More than just . and ..
									?>
										<div class="img-gallery">
											<?php 
											foreach($file as $img):
												if(in_array($img,array('.','..')))
													continue;
											?>
												<div class="img-item">
													<img src="<?php echo base_url.$upload_path.'/'.$img."?v=".(time()) ?>" 
														 class="img-thumbnail" alt="Banner Image">
													<button class="btn btn-sm btn-danger btn-remove rem_img" type="button" 
															data-path="<?php echo base_app.$upload_path.'/'.$img ?>">
														<i class="fa fa-trash"></i>
													</button>
												</div>
											<?php endforeach; ?>
										</div>
									<?php else: ?>
										<div class="alert alert-info p-2 text-center">
											<small><i>No banner images uploaded yet.</i></small>
										</div>
									<?php endif; ?>
									<?php endif; ?>
								</div>
							</div>
							
							<!-- Additional Settings Section -->
							<div class="form-section">
								<div class="form-section-title">Additional Settings</div>
								
								<div class="alert alert-info">
									<small>
										<i class="fa fa-info-circle"></i> 
										All changes will take effect immediately after updating.
									</small>
								</div>
								
								<div class="alert alert-warning">
									<small>
										<i class="fa fa-exclamation-triangle"></i> 
										Make sure all uploaded images are optimized for web to ensure fast loading times.
									</small>
								</div>
							</div>
						</div>
					</div>
				</div>
			</form>
		</div>
		
		<div class="card-footer">
			<div class="col-md-12 text-right">
				<button class="btn btn-sm btn-primary btn-flat" form="system-frm">
					<i class="fa fa-save"></i> Update Settings
				</button>
				<button type="button" class="btn btn-sm btn-default btn-flat" onclick="location.reload()">
					<i class="fa fa-times"></i> Cancel
				</button>
			</div>
		</div>
	</div>
</div>

<script>
	function displayImg(input,_this) {
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function (e) {
				$('#cimg').attr('src', e.target.result);
				_this.siblings('.custom-file-label').html(input.files[0].name)
			}
			reader.readAsDataURL(input.files[0]);
		}
	}
	
	function displayImg2(input,_this) {
		if (input.files && input.files[0]) {
			var reader = new FileReader();
			reader.onload = function (e) {
				_this.siblings('.custom-file-label').html(input.files[0].name)
				$('#cimg2').attr('src', e.target.result);
			}
			reader.readAsDataURL(input.files[0]);
		}
	}
	
	function displayImg3(input,_this) {
		var fnames = [];
		Object.keys(input.files).map(function(k){
			fnames.push(input.files[k].name)
		})
		_this.siblings('.custom-file-label').html(fnames.length + ' file(s) selected: ' + fnames.join(", ").substring(0, 50) + (fnames.join(", ").length > 50 ? '...' : ''));
	}
	
	function delete_img($path){
		start_loader()
		
		$.ajax({
			url: _base_url_+'classes/Master.php?f=delete_img',
			data:{path:$path},
			method:'POST',
			dataType:"json",
			error:err=>{
				console.log(err)
				alert_toast("An error occurred while deleting the image","error");
				end_loader()
			},
			success:function(resp){
				$('.modal').modal('hide')
				if(typeof resp =='object' && resp.status == 'success'){
					$('[data-path="'+$path+'"]').closest('.img-item').hide('slow',function(){
						$('[data-path="'+$path+'"]').closest('.img-item').remove()
						
						// Check if gallery is empty
						if($('.img-gallery .img-item').length === 0) {
							$('.current-banners').html('<div class="alert alert-info p-2 text-center"><small><i>No banner images uploaded yet.</i></small></div>');
						}
					})
					alert_toast("Image Successfully Deleted","success");
				}else{
					console.log(resp)
					alert_toast("An error occurred while deleting the image","error");
				}
				end_loader()
			}
		})
	}
	
	$(document).ready(function(){
		$('.rem_img').click(function(){
			_conf("Are you sure you want to delete this banner image permanently?",'delete_img',["'"+$(this).attr('data-path')+"'"])
		})
		
		// Form submission
		$('#system-frm').submit(function(e){
			e.preventDefault()
			start_loader()
			$.ajax({
				url:_base_url_+'classes/SystemSettings.php?f=update_settings',
				data: new FormData($(this)[0]),
				cache: false,
				contentType: false,
				processData: false,
				method: 'POST',
				type: 'POST',
				error:err=>{
					console.log(err)
					alert_toast("An error occurred",'error');
					end_loader()
				},
				success:function(resp){
					if(resp == 1){
						location.reload()
					}else{
						console.log(resp)
						alert_toast("An error occurred",'error');
						end_loader()
					}
				}
			})
		})
	})
</script>