<?php 
require_once('./config.php'); 

// Set secure session parameters before starting
session_set_cookie_params(['secure' => true, 'httponly' => true, 'samesite' => 'Strict']);
session_start();

$error = '';

// Generate a token if one doesn't exist
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

if($_SERVER['REQUEST_METHOD'] === 'POST'){
    // 1. Validate CSRF Token here (if implemented)
    
    $client_code = trim($_POST['client_code'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if($client_code && $password){
        $stmt = $conn->prepare("SELECT id, password FROM client_list WHERE client_code = ? LIMIT 1");
        $stmt->execute([$client_code]);
        $client = $stmt->fetch(PDO::FETCH_ASSOC);

        if($client && password_verify($password, $client['password'])){
            // 2. Prevent Session Fixation
            session_regenerate_id(true);
            
            $_SESSION['client_id'] = $client['id'];
            header('Location: home.php');
            exit;
        } else {
            $error = "Invalid Client Code or Password.";
        }
    } else {
        $error = "Please enter both Client Code and Password.";
    }
}
?>
<!DOCTYPE html>
<html lang="en" class="" style="height: auto;">
<?php require_once('inc/header.php'); ?>
<body class="hold-transition login-page dark-mode" style="background-color: #1f2937;">
<script>
    start_loader();
</script>
<style>
    :root {
        --primary: #3b82f6;
        --primary-hover: #2563eb;
        --glass: rgba(255, 255, 255, 0.05);
        --glass-border: rgba(255, 255, 255, 0.1);
    }

    body {
        background: radial-gradient(circle at top left, #1e293b, #0f172a);
        background-image: linear-gradient(rgba(15, 23, 42, 0.8), rgba(15, 23, 42, 0.8)), 
                          url('<?php echo validate_image($_settings->info('cover')) ?>');
        background-size: cover;
        background-position: center;
        height: 100vh !important;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Inter', sans-serif;
    }

    .login-container {
        width: 100%;
        max-width: 420px;
        padding: 20px;
    }

    .glass-card {
        background: var(--glass);
        backdrop-filter: blur(12px);
        -webkit-backdrop-filter: blur(12px);
        border: 1px solid var(--glass-border);
        border-radius: 24px;
        padding: 40px;
        box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
    }

    .brand-title {
        font-size: 1.5rem;
        font-weight: 800;
        color: #fff;
        letter-spacing: -0.5px;
        margin-bottom: 8px;
        text-align: center;
    }

    .sub-title {
        color: #94a3b8;
        text-align: center;
        font-size: 0.9rem;
        margin-bottom: 32px;
    }

    .form-group-custom {
        position: relative;
        margin-bottom: 20px;
    }

    .form-group-custom i {
        position: absolute;
        left: 16px;
        top: 50%;
        transform: translateY(-50%);
        color: #64748b;
        transition: color 0.3s;
    }

    .form-input {
        width: 100%;
        background: rgba(0, 0, 0, 0.2);
        border: 1px solid var(--glass-border);
        border-radius: 12px;
        padding: 14px 16px 14px 45px;
        color: #fff;
        transition: all 0.3s;
        outline: none;
    }

    .form-input:focus {
        border-color: var(--primary);
        background: rgba(0, 0, 0, 0.4);
        box-shadow: 0 0 0 4px rgba(59, 130, 246, 0.1);
    }

    .btn-submit {
        width: 100%;
        background: var(--primary);
        color: white;
        border: none;
        border-radius: 12px;
        padding: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: transform 0.2s, background 0.2s;
        margin-top: 10px;
    }

    .btn-submit:hover {
        background: var(--primary-hover);
        transform: translateY(-1px);
    }

    .btn-submit:active {
        transform: translateY(0);
    }

    .admin-link {
        display: block;
        text-align: center;
        margin-top: 24px;
        color: #94a3b8;
        font-size: 0.85rem;
        text-decoration: none;
        transition: color 0.2s;
    }

    .admin-link:hover {
        color: #fff;
    }

    .error-toast {
        background: rgba(239, 68, 68, 0.1);
        border: 1px solid rgba(239, 68, 68, 0.2);
        color: #fca5a5;
        padding: 12px;
        border-radius: 10px;
        font-size: 0.85rem;
        margin-bottom: 20px;
        text-align: center;
    }
</style>

<div class="login-container">
    <div class="glass-card">
        <div class="brand-title"><?php echo $_settings->info('name') ?></div>
        <div class="sub-title">Secure Client Portal</div>

        <?php if($error): ?>
            <div class="error-toast"><i class="fas fa-exclamation-circle mr-2"></i> <?= $error ?></div>
        <?php endif; ?>

        <form id="clogin-frm" action="" method="post">
            <input type="hidden" name="csrf_token" value="<?php echo $_SESSION['csrf_token']; ?>">
            <div class="form-group-custom">
                <i class="fas fa-user-tag"></i>
                <input type="text" class="form-input" name="client_code" placeholder="Client Code" required autofocus>
            </div>
            
            <div class="form-group-custom">
                <i class="fas fa-shield-alt"></i>
                <input type="password" class="form-input" name="password" placeholder="Password" required>
            </div>

            <button type="submit" class="btn-submit">Sign In to Dashboard</button>
        </form>

        <a href="<?php echo base_url.'admin' ?>" class="admin-link">
            System Administrator? <span style="color: var(--primary)">Login here</span>
        </a>
    </div>
</div>

<script src="plugins/jquery/jquery.min.js"></script>
<script src="plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="dist/js/adminlte.min.js"></script>
<script>
$(document).ready(function(){
    end_loader();
});
</script>
</body>
</html>
