<?php require_once('../config.php') ?>
<!DOCTYPE html>
<html lang="en">
<?php require_once('inc/header.php') ?>
<body class="hold-transition login-page">
  <script>start_loader()</script>
  
  <style>
    :root {
        --primary: #3b82f6;
        --primary-hover: #2563eb;
        --glass: rgba(255, 255, 255, 0.05);
        --glass-border: rgba(255, 255, 255, 0.1);
    }

    body {
       background: radial-gradient(circle at top left, #1e293b, #0f172a);
        background-image: linear-gradient(rgba(15, 23, 42, 0.8), rgba(15, 23, 42, 0.8)), 
                          url('<?php echo validate_image($_settings->info('cover')) ?>');
      background-size: cover;
      background-position: center;
      background-attachment: fixed;
      display: flex;
      align-items: center;
      justify-content: center;
      height: 100vh;
      margin: 0;
      color: #fff;
    }

    .login-box {
      width: 420px;
      perspective: 1000px;
    }

    .login-title {
      font-weight: 800;
      font-size: 1.4rem;
      letter-spacing: 1px;
      margin-bottom: 1.5rem;
      color: #fff;
      text-transform: uppercase;
    }

    .card {
      background: var(--glass-bg);
      backdrop-filter: blur(15px);
      border: 1px solid var(--glass-border);
      border-radius: 20px;
      box-shadow: 0 15px 35px rgba(0, 0, 0, 0.5);
      overflow: hidden;
    }

    .card-header {
      background: rgba(255,255,255,0.03);
      border-bottom: 1px solid var(--glass-border);
      padding: 2rem 1rem;
    }

    .card-header .h1 {
      font-size: 1.5rem;
      font-weight: 600;
      color: var(--admin-accent) !important;
    }

    .form-control {
      background: rgba(255, 255, 255, 0.08);
      border: 1px solid transparent;
      color: #fff !important;
      border-radius: 10px;
      padding: 1.5rem 1rem;
      transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .form-control:focus {
      background: rgba(255, 255, 255, 0.12);
      border-color: var(--admin-accent);
      box-shadow: 0 0 15px rgba(0, 210, 255, 0.3);
    }

    .input-group-text {
      background: rgba(255, 255, 255, 0.08);
      border: 1px solid transparent;
      border-left: 1px solid var(--glass-border);
      color: var(--admin-accent);
      border-radius: 0 10px 10px 0;
    }

    .btn-submit {
        width: 100%;
        background: var(--primary);
        color: white;
        border: none;
        border-radius: 12px;
        padding: 14px;
        font-weight: 600;
        cursor: pointer;
        transition: transform 0.2s, background 0.2s;
        margin-top: 10px;
    }

    .btn-submit:hover {
        background: var(--primary-hover);
        transform: translateY(-1px);
    }

    .btn-submit:active {
        transform: translateY(0);
    }

    .client-portal-link {
      color: rgba(255,255,255,0.5);
      font-size: 0.85rem;
      text-decoration: none;
      transition: 0.3s;
      display: inline-flex;
      align-items: center;
    }

    .client-portal-link:hover {
      color: var(--admin-accent);
    }

    /* Loader styling */
    #preloader { background: #000 !important; }
  </style>

<div class="login-box">
  <div class="card">
    <div class="card-header text-center">
         <h1 class="login-title"><?php echo $_settings->info('name') ?></h1>
      <span class="h1">Admin Login</span>
    </div>
    <div class="card-body p-4">
      <form id="login-frm" action="" method="post">
        <div class="input-group mb-4">
          <input type="text" class="form-control" autofocus name="username" placeholder="Username" required>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-user-shield"></span>
            </div>
          </div>
        </div>
        
        <div class="input-group mb-4">
          <input type="password" class="form-control" name="password" placeholder="Password" required>
          <div class="input-group-append">
            <div class="input-group-text">
              <span class="fas fa-key"></span>
            </div>
          </div>
        </div>

        <div class="row align-items-center">
          <div class="col-7">
            <a href="<?php echo base_url ?>" class="client-portal-link">
              <i class="fas fa-arrow-left mr-2"></i> Client Portal
            </a>
          </div>
          <div class="col-5">
            <button type="submit" class="btn btn-submit">Enter</button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="../plugins/jquery/jquery.min.js"></script>
<script src="../plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../dist/js/adminlte.min.js"></script>

<script>
  $(document).ready(function(){
    end_loader();
  })
</script>
</body>
</html>