<?php $__env->startSection('content'); ?>
<?php $input['date_range'] = !empty($input['date_range']) ? $input['date_range'] : null; ?>
<div class="container">
    <div class="row">
        <div class="col-md-8">
            <div class="panel panel-default">
                <div class="panel-heading">Inventory Trackings</div>

                <table class="table">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>User</th>
                            <th>Product</th>
                            <th>In</th>
                            <th>Out</th>
                            <th>Remarks</th>
                            <th>Date</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $trackings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tracking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php if(!empty($tracking->trackable)): ?>
                            <tr>
                                <td><?php echo e($trackings->firstItem() + $key); ?></td>
                                <td><?php echo e($tracking->user->name); ?></td>
                                <td><?php echo e(($tracking->product) ? $tracking->product->name : 'PROD-'.$tracking->product_id); ?></td>

                                    <?php if($tracking->trackable_type == 'App\SaleItem'): ?>
                                        <td>-</td>
                                        <td><?php echo e($tracking->trackable->quantity); ?></td>
                                        <td>Sales</td>
                                    <?php elseif($tracking->trackable_type == 'App\ReceivingItem'): ?>
                                        <td><?php echo e($tracking->trackable->quantity); ?></td>
                                        <td>-</td>
                                        <td>Receiving</td>
                                    <?php else: ?>
                                        <?php if($tracking->trackable->diff > 0): ?>
                                            <td><?php echo e($tracking->trackable->diff); ?></td>
                                            <td>-</td>
                                        <?php else: ?>
                                            <td>-</td>
                                            <td><?php echo e(abs($tracking->trackable->diff)); ?></td>
                                        <?php endif; ?>
                                        <td>Adjustment</td>
                                    <?php endif; ?>

                                <td><?php echo e($tracking->created_at->format('d F Y H:i')); ?></td>
                            </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php echo $__env->make('partials.table-blank-slate', ['colspan' => 7], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                    <?php endif; ?>
                    </tbody>
                </table>

                <div class="panel-footer" style="text-align: right;">
                    <?php echo e($trackings->links()); ?>

                </div> 
            </div>
        </div>

        <div class="col-md-4">
            <div class="panel panel-default">
                <div class="panel-heading">Filter</div>
                <div class="panel-body">
                    <form action="<?php echo e(url('inventories/trackings')); ?>" method="GET">
                        <div class="form-group">
                            <label class="control-label">Product</label>
                            
                        </div>
                        <div class="form-group">
                            <label for="price">Date Range</label>
                            <select class="form-control" id="date-range" name="date_range">
                                <option>-- Select Date Range --</option>
                                <option value="today" <?php echo e(($input['date_range'] == 'today') ? 'selected="selected"' : ''); ?>>Today</option>
                                <option value="current_week" <?php echo e(($input['date_range'] == 'current_week') ? 'selected="selected"' : ''); ?>>This Week</option>
                                <option value="current_month" <?php echo e(($input['date_range'] == 'current_month') ? 'selected="selected"' : ''); ?>>This Month</option>
                            </select>
                        </div>

                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">Filter</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>