<?php $__env->startSection( 'content' ); ?>

<?php $currency =  setting_by_key("currency"); ?>

<link href="<?php echo e(url('assets/css/plugins/sweetalert/sweetalert.css')); ?>" rel="stylesheet">

<link href="<?php echo e(url('assets/css/plugins/toastr/toastr.min.css')); ?>" rel="stylesheet">

<script src="<?php echo e(url('assets/js/plugins/toastr/toastr.min.js')); ?>"></script>

<script src="<?php echo e(url('assets/js/plugins/sweetalert/sweetalert.min.js')); ?>"></script>

<div class="wrapper wrapper-content animated fadeInRight">



	<div class="row">

		<div class="col-xs-12 col-sm-12 col-md-4 col-lg-4 pull-right">

			<div class="row">

				<div class="col-sm-12">

					

						<div class="ibox">

							<div class="ibox-title">

								<h5>Cart Items</h5>

							</div>

							<div class="ibox-content">

								<div id="CartHTML"></div>

							</div>

							<div class="panel-footer green-bg">

								<table width="100%" border="0" cellspacing="0" cellpadding="0">

								  <tbody>

									<tr>

									  <td><h4><strong>Total</strong></h4></td>

										<td class="text-right "><h4 class="TotalAmount">0</h4></td>

									</tr>

								  </tbody>

								</table>

							</div>

						</div>

					

				</div>

				<div class="col-sm-12">

					

						<div class="ibox">

							<div class="ibox-title">

								<h5>Finish Sale</h5>

							</div>

							<div class="ibox-content">

								<div class="row">

									<input type="hidden" id="cashier_id" class="form-control" value="<?php echo e(Auth::user()->id); ?>">

									<input type="hidden" id="customer_id" class="form-control" value="1">

									<input type="hidden" id="vat" class="form-control" value="0.00">

									<input type="hidden" id="delivery_cost" class="form-control" value="0">

									<div class="col-sm-12">

										<div class="form-group">

											<input type="text" id="discount" placeholder="Discount" class="form-control">

										</div>

									</div>

									<div class="col-sm-12">

										<div class="form-group">

											<select id="payment_type" class="form-control">

												<option value="Cash">By Cash</option>

												<option value="Card">By Card</option>

											</select>

											<input type="hidden" id="total_amount" placeholder="Total Paid" class="form-control">

										</div>

									</div>

									<div class="col-sm-12">

										<div class="form-group">

											<input type="text" id="total_given" placeholder="Total Paid" class="form-control">

										</div>

									</div>

									<div class="col-sm-12">

										<div class="form-group">

											<input type="text" id="change" readonly placeholder="Change" class="form-control">

										</div>

									</div>

									<div class="col-sm-12">

										<div class="form-group">

											<textarea id="comments" placeholder="Comment" class="form-control"></textarea>

										</div>

									</div>

									<div class="col-sm-6 col-md-12 col-lg-6">

										<div class="form-group">

											<button type="button" id="completeOrder" class="btn btn-primary btn-block text-center">Order Confirm</button>

										</div>

									</div>

									<div class="col-sm-6 col-md-12 col-lg-6">

										<div class="form-group">

											<button type="button" id="ClearCart" class="btn btn-danger btn-block text-center">Clear Cart</button>

										</div>

									</div>

								</div>

							</div>

						</div>

					

				</div>

			</div>

		</div>

		<div class="col-sm-12 col-md-8 col-lg-8">

			<div class="ibox float-e-margins">

				<div class="ibox-title">

					<div class="toolbar mb2 mt2">

						<button class="btn fil-cat" href="" data-rel="all">All</button> <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

						<button class="btn fil-cat" data-rel="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></button> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



					</div>





				</div>

				<div class="row" id="portfolio">

				

						<?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>



						<div class="col-xs-12 col-sm-6 col-md-6 col-lg-3 <?php echo e($product->category_id); ?> all">

							<div class="widget white-bg text-center product_list h-100">

																	

								<?php if(file_exists('uploads/products/thumb/' . $product->id . '.jpg')): ?>

									<img width="100px" alt="image" class="img-circle" src="<?php echo e(url('uploads/products/thumb/' . $product->id . '.jpg')); ?>"> 

									<h2 style="margin-top:3px" class="m-xs heading-size_image"><?php echo e($product->name); ?></h2>

								<?php else: ?>

								<div style="color:#FFF;background-color:#19A689; padding:49px 2px ; margin-bottom:10px; margin-top:-16px;">

									<h2 style="margin-top:3px" class="m-xs heading-size"><?php echo e($product->name); ?></h2>

								</div>

								<?php endif; ?>									

								<?php $prices = json_decode($product->prices); $titles = json_decode($product->titles);?>

								<?php $__currentLoopData = $titles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

									<button data-price="<?php echo e($prices[$key]); ?>" data-id="<?php echo e($product->id); ?>" data-key="<?php echo e($key); ?>" data-size="<?php echo e($t); ?>" data-name="<?php echo e($product->name); ?>" type="button" class="btn btn-sm btn-primary m-r-sm AddToCart tag-margin tag-btn"><?php echo e($t); ?></button>

								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



								

							</div>

						</div>

						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

					</div>

				



			</div>

		</div>

	</div>

</div>

<script src="<?php echo e(url('assets/js/lodash.min.js')); ?>"></script>



<script>

	$( "body" ).on( "keyup", "#total_given", function () {

		var total_amount = $( "#total_amount" ).val();

		var total_given = $( this ).val();

		var change = Number( total_given ) - Number( total_amount );

		$( "#change" ).val( change.toFixed( 2 ) );

	} );

	toastr.options = {

		"closeButton": true,

		"debug": false,

		"progressBar": true,

		"preventDuplicates": false,

		"positionClass": "toast-top-right",

		"onclick": null,

		"showDuration": "400",

		"hideDuration": "1000",

		"timeOut": "2000",

		"extendedTimeOut": "1000",

		"showEasing": "swing",

		"hideEasing": "linear",

		"showMethod": "fadeIn",

		"hideMethod": "fadeOut"

	}



	var products = new Array();
	var count_items = 0;

	var cart = new Array();

	$( "body" ).on( "click", ".AddToCart", function () { 
		count_items++; 
		var ids = _.map( cart, 'id' );
		var item = {

			id: $( this ).attr( "data-id" ) + $( this ).attr( "data-key" ),

			product_id: $( this ).attr( "data-id" ),

			price: $( this ).attr( "data-price" ),

			size: $( this ).attr( "data-size" ),

			name: $( this ).attr( "data-name" )

		};



		if ( !_.includes( ids, item.id ) ) {

			item.quantity = 1;

			item.p_qty = 1;

			cart.push( item );

		} else {

			var index = _.findIndex( cart, item );

			cart[ index ].quantity = cart[ index ].quantity + 1

		}




		toastr.success( 'Successfully Added to Cart' )

		show_cart();





	} );





	$( "body" ).on( "click", "#ClearCart", function () {



		var cart = [];

		$( ".TotalAmount" ).html( 0 );

		$( "#CartHTML" ).html( "" );

	} );

	$( "body" ).on( "click", ".DecreaseToCart", function () {

		var item = {

			id: $( this ).attr( "data-id" )

		};

		var index = _.findIndex( cart, item );



		if ( cart[ index ].quantity == 1 ) {

			deleteItemFromCart( item );

		} else {

			cart[ index ].quantity = cart[ index ].quantity - 1;

		}

		//console.log(cart[index].quantity);

		//toastr.success('Successfully Updated')       

		show_cart();



	} );



	$( "body" ).on( "click", ".IncreaseToCart", function () {

		var item = {

			id: $( this ).attr( "data-id" )

		};

		var index = _.findIndex( cart, item );

		cart[ index ].quantity = cart[ index ].quantity + 1;

		show_cart();



	} );



	$( "body" ).on( "click", ".DeleteItem", function () {

		var item = {

			id: $( this ).attr( "data-id" )

		};



		deleteItemFromCart( item );

	} );



	$( "body" ).on( "click", ".DiscountItem", function () {



	} );



	function deleteItemFromCart( item ) {

		var index = _.findIndex( cart, item );

		cart.splice( index, 1 );

		show_cart();

	}



	$( "body" ).on( "click", "#completeOrder", function () {

		if ( cart.length < 1 ) {

			swal( "", "Cart is Empty", "error" );

			return false;

		}

		var form_data = {

			comments: $( "#comments" ).val(),

			discount: $( "#discount" ).val(),

			cashier_id: $( "#cashier_id" ).val(),			payment_type: $( "#payment_type" ).val(),			total_given: $( "#total_given" ).val(),			change: $( "#change" ).val(),

			vat: $( "#vat" ).val(),

			delivery_cost: $( "#delivery_cost" ).val(),

			customer_id: $( "#customer_id" ).val(),

			items: _.map( cart, function ( cart ) {

				return {

					product_id: cart.product_id,

					size: cart.size,

					quantity: cart.quantity,

					price: cart.price

				}

			} )

		};

		var total_amount = Number( localStorage.getItem( "total_amount" ) );

		_.map( cart, function ( cart ) {

			localStorage.setItem( "total_amount", total_amount + ( cart.quantity * cart.price ) );

		} );



		$( "#completeOrder" ).html( '<i class="fa fa-spinner fa-spin" style="font-size:18px"></i>' );

		$( "#completeOrder" ).prop( "disabled", true );





		$.ajax( {

			type: 'POST',

			headers: {

				'X-CSRF-TOKEN': $( 'meta[name="csrf-token"]' ).attr( 'content' )

			},

			url: '<?php echo url("sales/complete_sale"); ?>',

			data: form_data,

			success: function ( msg ) {

				cart = [];

				$( "#comments" ).val( "" );

				$( "#completeOrder" ).html( 'Order Confirm' );

				$( "#completeOrder" ).prop( "disabled", false );

				swal( {

					title: 'Sale Completed',

					type: 'success',

					text: ''

				} ).then(

					function () {

						window.open( msg, "_blank" );

						if ( Number( localStorage.getItem( "total_amount" ) ) >= 500 ) {

							swal( "$500 of sales", "Empty the cash drawer", "error" );

							localStorage.setItem( "total_amount", 0 );

						}

					}

				)



				show_cart();

			}

		} );



	} );







	function show_cart() {

		if ( cart.length > 0 ) {

			var qty = 0;

			var total = 0;

			var cart_html = "";

			var obj = cart;

			$.each( obj, function ( key, value ) {



				cart_html += '<table width="100%" border="0" style="border-spacing: 5px; border-collapse: separate;" class=""><tbody>';

				cart_html += '<tr>';

				cart_html += '<td width="10" valign="top"><a href="javascript:void(0)" class="text-danger DeleteItem" data-id=' + value.id + '><i class="fa fa-trash"></i></a></td>';

				cart_html += '<td><h4 style="margin:0px;">' + value.name + '</h4></td>';

				//cart_html += '';

				cart_html += '<td width="80"><span class="btn btn-primary btn-sm text-center IncreaseToCart" data-id=' + value.id + '>+</span> '+ value.quantity +' <span  class="btn btn-primary btn-sm DecreaseToCart" data-id=' + value.id + '>-</span> </td>';

				//cart_html += '<div class="col-lg-1 no-pad"></div>';



				cart_html += '<td width="15%" class="text-right"><h4 style="margin:0px;"> <?php echo $currency; ?>' + value.price + '</h4> </td>'

				



				cart_html += '</tr>';

				cart_html += '</tbody></table>';





				qty = Number( value.quantity );

				total = Number( total ) + Number( value.price * qty );



			} );

				var vat = ( Number( total ) * <?php echo setting_by_key("vat"); ?> ) / 100;

				cart_html += '<hr><table width="100%" border="0" style="border-spacing: 5px; border-collapse: separate;" class=""><tbody>';
				
				//// Sub Total 

				cart_html += '<tr>';

				cart_html += '<td><h4>Sub Total</h4></td>';

				cart_html += '<td class="text-right"><h4><?php echo $currency; ?>' + total + '</h4></td>';

				cart_html += '</tr>';
				
				//// Discount 
				var discount = 0; 
				if(Number(count_items) >= 2) { 
					discount = <?php echo setting_by_key('discount'); ?>;
				}
				
				$("#discount").val(discount);
				
				cart_html += '<tr>';

				cart_html += '<td><h4>Discount</h4></td>';

				cart_html += '<td class="text-right"><h4><?php echo $currency; ?>' + discount + '</h4></td>';

				cart_html += '</tr>';
				
				
				cart_html += '<tr>';

				cart_html += '<td><h4>HST(<?php echo setting_by_key("vat"); ?>%)</h4></td>';

				cart_html += '<td class="text-right"><h4><?php echo $currency; ?>' + vat + '</h4></td>';

				cart_html += '</tr>';
			
			

				cart_html += '</tbody></table>';



			// cart_html += '<div class="panel-footer"> Total Items' ;

			// cart_html += '<span class="pull-right"> ' + qty ;

			// cart_html += '</span></div>' ;



			var total_amount = Number( total ) + vat - discount;

			$( "#total_amount" ).val( total_amount );
			$( "#vat" ).val( vat );



			$( ".TotalAmount" ).html( "<?php echo $currency; ?>" + total_amount.toFixed( 2 ) );

			$( "#CartHTML" ).html( "" );

			$( "#CartHTML" ).html( cart_html );

		} else {

			$( ".TotalAmount" ).html( 0 );

			$( "#CartHTML" ).html( "" );

		}



	}

</script>



<style>

	.cart-item {

		max-height: 160px;

		overflow-y: scroll;

	}

	

	.scale-anm {

		transform: scale(1);

	}

	

	.tile {

		-webkit-transform: scale(0);

		transform: scale(0);

		-webkit-transition: all 350ms ease;

		transition: all 350ms ease;

	}

	

	.tile:hover {}

	

	.product_list {

		min-height: 255px !important;

	}

</style>



<script>

	$( "body" ).on( "click", ".close", function () {

		alert( "close" );

	} );

	$( function () {

		var selectedClass = "";

		$( ".fil-cat" ).click( function () {

			selectedClass = $( this ).attr( "data-rel" );			

			$( "#portfolio" ).fadeTo( 100, 0.1 );

			$( "#portfolio > div" ).not( "." + selectedClass ).fadeOut().removeClass( 'scale-anm' );

			setTimeout( function () {

				$( "." + selectedClass ).fadeIn().addClass( 'scale-anm' );

				$( "#portfolio" ).fadeTo( 300, 1 );

			}, 300 );



		} );

	} );			

</script>



<?php $__env->stopSection(); ?>
<?php echo $__env->make( 'layouts.app' , array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>