<?php
include('config.php');
session_start();
date_default_timezone_set('Asia/Kathmandu');
?>
<!DOCTYPE HTML>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>OMTBS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Styles -->
  <link rel="stylesheet" href="css/style.css">
  <link rel="stylesheet" href="css/flexslider.css">
  <link rel="stylesheet" href="css/tsc_tabs.css">
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">

  <!-- Scripts -->
  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <script src="js/jquery.color-RGBa-patch.js"></script>
  <script src="js/example.js"></script>
  <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
</head>

<body>
<!-- Navigation Bar -->
<nav class="navbar navbar-inverse navbar-static-top">
  <div class="container">
    
    <!-- Logo & Mobile Toggle -->
    <div class="navbar-header">
      <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#omtbs-navbar">
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
        <span class="icon-bar"></span>
      </button>
      <a class="navbar-brand" href="index.php">
        <img src="images/t-logo.png" alt="OMTBS Logo" style="max-height:40px;">
      </a>
    </div>

    <!-- Navbar Content -->
    <div class="collapse navbar-collapse" id="omtbs-navbar">
      <ul class="nav navbar-nav">
        <li><a href="index.php">Home</a></li>
        <li><a href="movies_events.php">Movies</a></li>
      </ul>

      <!-- Search Form -->
      <form class="navbar-form navbar-left" action="process_search.php" method="post" onsubmit="return validateSearch()">
        <div class="form-group">
          <input type="text" class="form-control" name="search" id="search111" placeholder="Search movies..." required>
        </div>
        <button type="submit" class="btn btn-default">Search</button>
      </form>

      <!-- User Account -->
      <ul class="nav navbar-nav navbar-right">
        <?php 
        if (isset($_SESSION['user'])) {
          $us = mysqli_query($con, "SELECT * FROM tbl_registration WHERE user_id='{$_SESSION['user']}'");
          $user = mysqli_fetch_array($us);
          echo "<li><a href='profile.php'>{$user['name']}</a></li>";
          echo "<li><a href='logout.php'>Logout</a></li>";
        } else {
          echo "<li><a href='login.php'>Login</a></li>";
          echo "<li><a href='registration.php'>Register</a></li>";
        }
        ?>
      </ul>
    </div>
  </div>
</nav>

<script>
function validateSearch() {
  var input = document.getElementById("search111").value.trim();
  if (input === "") {
    alert("Please enter a movie name...");
    return false;
  }
  return true;
}
</script>
