<?php
include('header.php');

// Check if user is logged in
if (!isset($_SESSION['theatre'])) {
  header('Location: login.php');
  exit;
}
?>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <h1>User Details</h1>
    <ol class="breadcrumb">
      <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
      <li class="active">User Details</li>
    </ol>
  </section>

  <!-- Main content -->
  <section class="content">
    <div class="box">
      <div class="box-header with-border">
        <h3 class="box-title">Edit User Details</h3>
      </div>
      <div class="box-body">
        <?php
        // Fetch current user info
        $th = mysqli_query($con, "SELECT * FROM tbl_login WHERE user_id='" . $_SESSION['theatre'] . "'");
        $theatre = mysqli_fetch_array($th);

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
          $current_password = $_POST['current_password'];
          $new_username = mysqli_real_escape_string($con, $_POST['username']);
          $raw_password = $_POST['password'];
          $stored_hash = $theatre['password'];

          // Verify current password
          if (!password_verify($current_password, $stored_hash)) {
            echo "<div class='alert alert-danger'>Current password is incorrect.</div>";
          } else {
            // Update logic
            if (!empty($raw_password)) {
              $hashed_password = password_hash($raw_password, PASSWORD_DEFAULT);
              $update = mysqli_query($con, "UPDATE tbl_login SET username='$new_username', password='$hashed_password' WHERE user_id='" . $_SESSION['theatre'] . "'");
            } else {
              $update = mysqli_query($con, "UPDATE tbl_login SET username='$new_username' WHERE user_id='" . $_SESSION['theatre'] . "'");
            }

            if ($update) {
              echo "<div class='alert alert-success'>User details updated successfully.</div>";
              // Refresh user data
              $th = mysqli_query($con, "SELECT * FROM tbl_login WHERE user_id='" . $_SESSION['theatre'] . "'");
              $theatre = mysqli_fetch_array($th);
            } else {
              echo "<div class='alert alert-danger'>Update failed. Please try again.</div>";
            }
          }
        }
        ?>

        <form method="post">
          <table class="table table-bordered table-hover">
            <tr>
              <td class="col-md-6"><label for="username">User Name</label></td>
              <td class="col-md-6">
                <input type="text" name="username" id="username" class="form-control"
                  value="<?php echo htmlspecialchars($theatre['username']); ?>" required>
              </td>
            </tr>
            <tr>
              <td><label for="current_password">Current Password</label></td>
              <td>
                <input type="password" name="current_password" id="current_password" class="form-control"
                  placeholder="Enter current password" required>
              </td>
            </tr>
            <tr>
              <td><label for="password">New Password</label></td>
              <td>
                <input type="password" name="password" id="password" class="form-control"
                  placeholder="Leave blank to keep current password">
              </td>
            </tr>
            <tr>
              <td colspan="2" class="text-center">
                <button type="submit" class="btn btn-success">
                  <i class="fa fa-save"></i> Update
                </button>
              </td>
            </tr>
          </table>
        </form>
      </div>
    </div>
  </section>
</div>

<?php
include('footer.php');
?>
