<?php
include('header.php');
?>
<div class="content-wrapper">
  <section class="content-header">
    <h1>Theater Details</h1>
    <ol class="breadcrumb">
      <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
      <li class="active">Theatre Lists</li>
    </ol>
  </section>

  <section class="content">
      <?php if (isset($_GET['msg'])): ?>
  <div class="alert alert-success alert-dismissible">
    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
    <?php
      if ($_GET['msg'] == 'updated') {
        echo "Theatre updated successfully.";
      } elseif ($_GET['msg'] == 'deleted') {
        echo "Theatre deleted successfully.";
      } elseif ($_GET['msg'] == 'added') {
        echo "Theatre added successfully.";
      }
    ?>
  </div>
<?php endif; ?>

    <div class="box">
      <div class="box-body" id="screendtls">
        <?php
        $sr = mysqli_query($con, "SELECT * FROM tbl_theatre");
        if (mysqli_num_rows($sr)) {
        ?>
          <table class="table table-bordered table-hover">
  <thead>
    <tr>
      <th class="col-md-1">Sr</th>
      <th class="col-md-3">Theatre Name</th>
      <th class="col-md-1">Place</th>
      <th class="col-md-3">Address</th>
      <th class="col-md-1">State</th>
      <th class="col-md-1">Pin</th>
      <th class="col-md-2">Actions</th>
    </tr>
  </thead>
  <tbody>
    <?php 
    $sl = 1;
    while ($screen = mysqli_fetch_array($sr)) {
    ?>
    <tr>
      <td><?php echo $sl; ?></td>
      <td><?php echo $screen['name']; ?></td>
      <td><?php echo $screen['place']; ?></td>
      <td><?php echo $screen['address']; ?></td>
      <td><?php echo $screen['state']; ?></td>
      <td><?php echo $screen['pin']; ?></td>
      <td>
        <a href="edit_theatre.php?id=<?php echo $screen['id']; ?>" class="btn btn-sm btn-primary">
          <i class="fa fa-edit"></i> Edit
        </a>
        <a href="delete_theatre.php?id=<?php echo $screen['id']; ?>" 
           class="btn btn-sm btn-danger" 
           onclick="return confirm('Are you sure you want to delete this theatre?');">
          <i class="fa fa-trash"></i> Delete
        </a>
      </td>
    </tr>
    <?php $sl++; } ?>
  </tbody>
</table>

        <?php
        } else {
        ?>
          <div class="alert alert-info">No theatres found.</div>
          <a href="add_theatre.php" class="btn btn-info"><i class="fa fa-plus"></i> Add Theatre</a>
        <?php
        }
        ?>
      </div>
    </div>
  </section>
</div>
<?php include('footer.php'); ?>
