<?php
include('../../config.php');
session_start();

$email = $_POST["Email"];
$pass = $_POST["Password"];

// Use prepared statement to prevent SQL injection
$stmt = $con->prepare("SELECT * FROM tbl_login WHERE username = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows) {
    $usr = $result->fetch_assoc();

    // Verify password hash
    if (password_verify($pass, $usr['password'])) {
        if ($usr['user_type'] == 0) {
            $_SESSION['admin'] = $usr['user_id'];
            header('Location: index.php');
            exit;
        } else {
            $_SESSION['error'] = "Login Failed!";
            header("Location: ../index.php");
            exit;
        }
    } else {
        $_SESSION['error'] = "Invalid password!";
        header("Location: ../index.php");
        exit;
    }
} else {
    $_SESSION['error'] = "User not found!";
    header("Location: ../index.php");
    exit;
}
?>
