<?php
include('header.php');
?>
<link rel="stylesheet" href="../../validation/dist/css/bootstrapValidator.css"/>
<script type="text/javascript" src="../../validation/dist/js/bootstrapValidator.js"></script>

<?php
include('../../form.php');
$frm = new formBuilder;
?>

<!-- Content Wrapper -->
<div class="content-wrapper">
  <section class="content-header">
    <h1>Add Theatre</h1>
    <ol class="breadcrumb">
      <li><a href="index.php"><i class="fa fa-home"></i> Home</a></li>
      <li class="active">Add Theatre</li>
    </ol>
  </section>

  <section class="content">
    <div class="box">
      <div class="box-body">
        <form action="process_add_theater.php" method="post" id="form1">
          <div class="form-group">
            <label class="control-label">Theatre Name</label>
            <input type="text" name="name" class="form-control"/>
            <?php $frm->validate("name", ["required", "label" => "Theatre Name"]); ?>
          </div>

          <div class="form-group">
            <label class="control-label">Theatre Address</label>
            <input type="text" name="address" class="form-control"/>
            <?php $frm->validate("address", ["required", "label" => "Theatre Address"]); ?>
          </div>

          <div class="form-group">
            <label class="control-label">Place</label>
            <input type="text" name="place" class="form-control">
            <?php $frm->validate("place", ["required", "label" => "Place"]); ?>
          </div>

          <div class="form-group">
            <label class="control-label">State</label>
            <input type="text" name="state" id="administrative_area_level_1" class="form-control" placeholder="State">
            <?php $frm->validate("state", ["required", "label" => "State"]); ?>
          </div>

          <div class="form-group">
            <label class="control-label">Pin Code</label>
            <input type="text" name="pin" id="postal_code" class="form-control" placeholder="Zip code">
            <?php $frm->validate("pin", ["required", "label" => "Pin Code", "regexp" => "pin"]); ?>
          </div>

          <?php
          start:
          $username = "THR" . rand(123456, 999999);
          $u = mysqli_query($con, "SELECT * FROM tbl_login WHERE username='$username'");
          if (mysqli_num_rows($u)) {
              goto start;
          }
          ?>

          <div class="form-group">
            <label class="control-label">Username</label>
            <input type="text" name="username" class="form-control" value="<?php echo $username ?>">
            <?php $frm->validate("username", ["required", "label" => "Username"]); ?>
          </div>

          <!-- Secure Password Section -->
          <?php $genPwd = "PWD" . rand(123456, 999999); ?>
          <div class="form-group">
            <label class="control-label">Password</label>
            <input type="password" name="password" id="password" class="form-control" value="<?php echo $genPwd; ?>">
            <?php $frm->validate("password", ["required", "label" => "Password"]); ?>
          </div>

          <div class="form-group">
            <label class="control-label">Confirm Password</label>
            <input type="password" name="confirm_password" id="confirm_password" class="form-control">
            <?php $frm->validate("confirm_password", ["required", "label" => "Confirm Password", "equalTo" => "password"]); ?>
          </div>

          <div class="form-group">
            <input type="checkbox" id="togglePassword"> <label for="togglePassword"> Show Password</label>
          </div>

          <div class="form-group">
            <button class="btn btn-success">Add Theatre</button>
          </div>

          <!-- Hidden fields for Google Maps Autocomplete -->
          <input type="hidden" name="country" class="form-control" id="country">
          <input type="hidden" class="field" id="route" disabled="true">
          <input type="hidden" class="field" id="street_number" disabled="true">
          <input type="hidden" class="field" id="locality" disabled="true">
        </form>
      </div>
    </div>
  </section>
</div>

<?php include('footer.php'); ?>

<!-- Google Places API Autocomplete -->
<script>
  var placeSearch, autocomplete;
  var componentForm = {
    street_number: 'short_name',
    route: 'long_name',
    locality: 'long_name',
    administrative_area_level_1: 'long_name',
    country: 'long_name',
    postal_code: 'short_name'
  };

  function initAutocomplete() {
    autocomplete = new google.maps.places.Autocomplete(
      document.getElementById('autocomplete'),
      { types: ['geocode'] }
    );
    autocomplete.addListener('place_changed', fillInAddress);
  }

  function fillInAddress() {
    var place = autocomplete.getPlace();
    for (var component in componentForm) {
      if (document.getElementById(component)) {
        document.getElementById(component).value = '';
        document.getElementById(component).disabled = false;
      }
    }

    for (var i = 0; i < place.address_components.length; i++) {
      var addressType = place.address_components[i].types[0];
      if (componentForm[addressType] && document.getElementById(addressType)) {
        var val = place.address_components[i][componentForm[addressType]];
        document.getElementById(addressType).value = val;
      }
    }
  }
</script>

<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDfO40iueprTDv0WCf0BCIlbj56JO-HylA&libraries=places&callback=initAutocomplete" async defer></script>

<!-- Show/Hide Password Script -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const toggle = document.getElementById('togglePassword');
    const pwdField = document.getElementById('password');
    const confirmField = document.getElementById('confirm_password');

    toggle.addEventListener('change', function () {
      const type = this.checked ? 'text' : 'password';
      pwdField.type = type;
      confirmField.type = type;
    });
  });
</script>

<!-- Apply form validation -->
<script>
  <?php $frm->applyvalidations("form1"); ?>
</script>
