<?php
session_start();
require_once 'connect.php';

// Redirect if not logged in
if (!isset($_SESSION['email'], $_SESSION['id'])) {
    header('Location: login.php');
    exit;
}

/* ===============================
   Fetch Website Logo
================================ */
$logo = 'default.png';
$logoQuery = $conn->query("SELECT logo FROM manage_website LIMIT 1");
if ($logoQuery && $logoQuery->num_rows > 0) {
    $logoRow = $logoQuery->fetch_assoc();
    $logo = $logoRow['logo'];
}

/* ===============================
   Fetch Admin Info
================================ */
$adminStmt = $conn->prepare("SELECT fname, lname, email, contact, dob, gender, image FROM admin WHERE id = ?");
$adminStmt->bind_param("i", $_SESSION['id']);
$adminStmt->execute();
$admin = $adminStmt->get_result()->fetch_assoc();

$profileImage = !empty($admin['image']) ? $admin['image'] : 'default_user.png';
?>

<!-- Main wrapper -->
<div id="main-wrapper">

    <!-- Header -->
    <div class="header">
        <nav class="navbar top-navbar navbar-expand-md navbar-light">

            <!-- Logo -->
            <div class="navbar-header">
                <a class="navbar-brand" href="index.php">
                    <b>
                        <img src="uploadImage/Logo/<?= htmlspecialchars($logo) ?>"
                             alt="Homepage"
                             class="dark-logo"
                             style="width:30%; height:auto;">
                    </b>
                </a>
            </div>
            <!-- End Logo -->

            <div class="navbar-collapse">

                <!-- Toggle buttons -->
                <ul class="navbar-nav mr-auto mt-md-0">
                    <li class="nav-item">
                        <a class="nav-link nav-toggler hidden-md-up text-muted" href="javascript:void(0)">
                            <i class="mdi mdi-menu"></i>
                        </a>
                    </li>
                    <li class="nav-item m-l-10">
                        <a class="nav-link sidebartoggler hidden-sm-down text-muted" href="javascript:void(0)">
                            <i class="ti-menu"></i>
                        </a>
                    </li>
                </ul>

                <!-- User dropdown -->
                <ul class="navbar-nav my-lg-0">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle text-muted"
                           href="#"
                           data-toggle="dropdown"
                           aria-haspopup="true"
                           aria-expanded="false">

                            <img src="uploadImage/Profile/<?= htmlspecialchars($profileImage) ?>"
                                 alt="User"
                                 class="profile-pic">
                        </a>

                        <div class="dropdown-menu dropdown-menu-right animated zoomIn">
                            <ul class="dropdown-user">
                                <li>
                                    <a href="profile.php">
                                        <i class="ti-user"></i> Profile
                                    </a>
                                </li>
                                <li>
                                    <a href="changepassword.php">
                                        <i class="ti-key"></i> Change Password
                                    </a>
                                </li>
                                <li>
                                    <a href="logout.php">
                                        <i class="fa fa-power-off"></i> Logout
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </li>
                </ul>

            </div>
        </nav>
    </div>