<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Login | Bus Ticket Booking</title>
    <?php include('header.php'); ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5 CSS (If not already included) -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            background-image: url(./assets/img/bsimgstat.png);
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 15px;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .login-card {
            background-color: rgba(255, 255, 255, 0.95);
            border-radius: 12px;
            box-shadow: 0 0 30px rgba(0, 0, 0, 0.2);
            max-width: 400px;
            width: 100%;
        }

        .card-header-edge {
            background: #007bff;
            padding: 15px;
            font-size: 20px;
            color: #fff;
            font-weight: bold;
            border-top-left-radius: 12px;
            border-top-right-radius: 12px;
            text-align: center;
        }

        .form-group label {
            font-weight: 500;
        }

        .btn-block {
            width: 100%;
        }

        a {
            display: inline-block;
            margin-top: 10px;
            font-size: 14px;
            text-align: center;
            width: 100%;
        }

        @media (max-width: 576px) {
            body {
                padding: 10px;
            }
        }
    </style>
</head>
<body>
    <div class="login-card card p-3">
        <div class="card-header-edge">
            Bus Ticket Booking
        </div>
        <div class="card-body">
            <form id="login-frm">
                <p class="text-center"><b>Admin Login</b></p>
                <div class="form-group mb-3">
                    <label for="username">Username</label>
                    <input type="text" name="username" class="form-control" required id="username">
                </div>
                <div class="form-group mb-3">
                    <label for="password">Password</label>
                    <input type="password" name="password" class="form-control" required id="password">
                </div> 
                <div class="form-group text-center">
                    <button type="submit" class="btn btn-success btn-block">Login as Admin</button>
                    <a href="./index.php">← Back to Home</a>
                </div>
            </form>
        </div>
    </div>

    <!-- jQuery + Bootstrap JS (optional if not already included) -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        $(document).ready(function(){
            $('#login-frm').submit(function(e){
                e.preventDefault();
                let btn = $('#login-frm button');
                btn.attr('disabled', true).text('Checking details...');

                $.ajax({
                    url: './login_auth.php',
                    method: 'POST',
                    data: $(this).serialize(),
                    error: function(err){
                        console.error(err);
                        alert('An error occurred.');
                        btn.removeAttr('disabled').text('Login as Admin');
                    },
                    success: function(resp){
                        if (resp == 1) {
                            location.replace('index.php?page=home');
                        } else {
                            alert("Incorrect username or password.");
                            btn.removeAttr('disabled').text('Login as Admin');
                        }
                    }
                });
            });
        });
    </script>
</body>
</html>
